/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class BatchRelationshipIterable
implements Iterable<RelationshipRecord> {
    private final NeoStore neoStore;
    private final RelationshipStore relStore;
    private final RelationshipGroupStore groupStore;
    private final long nodeId;

    public BatchRelationshipIterable(NeoStore neoStore, long nodeId) {
        this.neoStore = neoStore;
        this.relStore = neoStore.getRelationshipStore();
        this.groupStore = neoStore.getRelationshipGroupStore();
        this.nodeId = nodeId;
    }

    @Override
    public Iterator<RelationshipRecord> iterator() {
        NodeRecord nodeRecord = this.neoStore.getNodeStore().getRecord(this.nodeId);
        if (nodeRecord.isDense()) {
            return new DenseIterator(nodeRecord);
        }
        return new SparseIterator(nodeRecord);
    }

    public long nextRelationship(long relId, NodeRecord nodeRecord) {
        long nextRel;
        RelationshipRecord relRecord = this.relStore.getRecord(relId);
        long firstNode = relRecord.getFirstNode();
        long secondNode = relRecord.getSecondNode();
        if (firstNode == this.nodeId) {
            nextRel = relRecord.getFirstNextRel();
        } else if (secondNode == this.nodeId) {
            nextRel = relRecord.getSecondNextRel();
        } else {
            throw new InvalidRecordException("Node[" + this.nodeId + "] not part of firstNode[" + firstNode + "] or secondNode[" + secondNode + "]");
        }
        return nextRel;
    }

    private static enum GroupChain {
        OUT{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstOut();
            }
        }
        ,
        IN{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstIn();
            }
        }
        ,
        LOOP{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstLoop();
            }
        };


        abstract long chainStart(RelationshipGroupRecord var1);
    }

    public class DenseIterator
    extends PrefetchingIterator<RelationshipRecord> {
        private final NodeRecord nodeRecord;
        private RelationshipGroupRecord groupRecord;
        private int groupChainIndex;
        private long nextRelId;

        public DenseIterator(NodeRecord nodeRecord) {
            this.nodeRecord = nodeRecord;
            this.groupRecord = BatchRelationshipIterable.this.groupStore.getRecord(nodeRecord.getNextRel());
            this.nextRelId = this.nextChainStart();
        }

        private long nextChainStart() {
            while (this.groupRecord != null) {
                while (this.groupChainIndex < GroupChain.values().length) {
                    long chainStart = GroupChain.values()[this.groupChainIndex++].chainStart(this.groupRecord);
                    if (chainStart == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) continue;
                    return chainStart;
                }
                this.groupRecord = this.groupRecord.getNext() != (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? BatchRelationshipIterable.this.groupStore.getRecord(this.groupRecord.getNext()) : null;
                this.groupChainIndex = 0;
            }
            return Record.NO_NEXT_RELATIONSHIP.intValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected RelationshipRecord fetchNextOrNull() {
            if (this.nextRelId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                return null;
            }
            try {
                RelationshipRecord relationshipRecord = BatchRelationshipIterable.this.relStore.getRecord(this.nextRelId);
                return relationshipRecord;
            }
            finally {
                this.nextRelId = BatchRelationshipIterable.this.nextRelationship(this.nextRelId, this.nodeRecord);
                if (this.nextRelId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                    this.nextRelId = this.nextChainStart();
                }
            }
        }
    }

    public class SparseIterator
    extends PrefetchingIterator<RelationshipRecord> {
        private final NodeRecord nodeRecord;
        private long nextRelId;

        public SparseIterator(NodeRecord nodeRecord) {
            this.nodeRecord = nodeRecord;
            this.nextRelId = nodeRecord.getNextRel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected RelationshipRecord fetchNextOrNull() {
            if (this.nextRelId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                return null;
            }
            try {
                RelationshipRecord relationshipRecord = BatchRelationshipIterable.this.relStore.getRecord(this.nextRelId);
                return relationshipRecord;
            }
            finally {
                this.nextRelId = BatchRelationshipIterable.this.nextRelationship(this.nextRelId, this.nodeRecord);
            }
        }
    }
}

