/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v19;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.LegacyDynamicStringStoreReader;

public class Legacy19PropertyIndexStoreReader
implements Closeable {
    public static final String FROM_VERSION = "PropertyIndexStore v0.A.0";
    public static final int RECORD_SIZE = 9;
    private final StoreChannel fileChannel;
    private final LegacyDynamicStringStoreReader nameStoreReader;
    private final long maxId;

    public Legacy19PropertyIndexStoreReader(FileSystemAbstraction fs, File file) throws IOException {
        this.fileChannel = fs.open(file, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 9L;
        this.nameStoreReader = new LegacyDynamicStringStoreReader(fs, new File(file.getPath() + ".keys"), "StringPropertyStore");
    }

    public Token[] readTokens() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[9]);
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (long id = 0L; id < this.maxId; ++id) {
            boolean inUse;
            Legacy19Store.readIntoBuffer(this.fileChannel, buffer, 9);
            byte inUseByte = buffer.get();
            boolean bl = inUse = inUseByte == Record.IN_USE.byteValue();
            if (inUseByte != Record.IN_USE.byteValue() && inUseByte != Record.NOT_IN_USE.byteValue()) {
                throw new InvalidRecordException("Record[" + id + "] unknown in use flag[" + inUse + "]");
            }
            if (!inUse) continue;
            buffer.getInt();
            int nameId = buffer.getInt();
            String name = this.nameStoreReader.readDynamicString(nameId);
            tokens.add(new Token(name, (int)id));
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    @Override
    public void close() throws IOException {
        this.nameStoreReader.close();
        this.fileChannel.close();
    }
}

