/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.Store;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class RelationshipGroupStore
extends AbstractRecordStore<RelationshipGroupRecord>
implements Store {
    public static final int RECORD_SIZE = 25;
    public static final String TYPE_DESCRIPTOR = "RelationshipGroupStore";
    private int denseNodeThreshold;

    public RelationshipGroupStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, StoreVersionMismatchHandler versionMismatchHandler, Monitors monitors) {
        super(fileName, config, IdType.RELATIONSHIP_GROUP, idGeneratorFactory, pageCache, fileSystemAbstraction, stringLogger, versionMismatchHandler, monitors);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RelationshipGroupRecord getRecord(long id) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(id), 1);){
            if (cursor.next()) {
                RelationshipGroupRecord record;
                do {
                    record = this.getRecord(id, cursor);
                } while (cursor.shouldRetry());
                if (record != null) {
                    RelationshipGroupRecord relationshipGroupRecord = record;
                    return relationshipGroupRecord;
                }
            }
            throw new InvalidRecordException("Record[" + id + "] not in use");
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public int getNumberOfReservedLowIds() {
        return 1;
    }

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        this.getFileChannel().position(0L);
        this.getFileChannel().read(buffer);
        buffer.flip();
        this.denseNodeThreshold = buffer.getInt();
        if (this.denseNodeThreshold < 0) {
            throw new InvalidRecordException("Illegal block size: " + this.denseNodeThreshold + " in " + this.getStorageFileName());
        }
    }

    private RelationshipGroupRecord getRecord(long id, PageCursor cursor) {
        boolean inUse;
        cursor.setOffset(this.offsetForId(id));
        long inUseByte = cursor.getByte();
        boolean bl = inUse = (inUseByte & 1L) > 0L;
        if (!inUse) {
            return null;
        }
        long highByte = cursor.getByte();
        int type = this.getUnsignedShort(cursor.getShort());
        long nextLowBits = cursor.getUnsignedInt();
        long nextOutLowBits = cursor.getUnsignedInt();
        long nextInLowBits = cursor.getUnsignedInt();
        long nextLoopLowBits = cursor.getUnsignedInt();
        long owningNode = cursor.getUnsignedInt() | (long)cursor.getByte() << 32;
        long nextMod = (inUseByte & 0xEL) << 31;
        long nextOutMod = (inUseByte & 0x70L) << 28;
        long nextInMod = (highByte & 0xEL) << 31;
        long nextLoopMod = (highByte & 0x70L) << 28;
        RelationshipGroupRecord record = new RelationshipGroupRecord(id, type);
        record.setInUse(inUse);
        record.setNext(RelationshipGroupStore.longFromIntAndMod(nextLowBits, nextMod));
        record.setFirstOut(RelationshipGroupStore.longFromIntAndMod(nextOutLowBits, nextOutMod));
        record.setFirstIn(RelationshipGroupStore.longFromIntAndMod(nextInLowBits, nextInMod));
        record.setFirstLoop(RelationshipGroupStore.longFromIntAndMod(nextLoopLowBits, nextLoopMod));
        record.setOwningNode(owningNode);
        return record;
    }

    @Override
    public void updateRecord(RelationshipGroupRecord record) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(record.getId()), 2);){
            if (cursor.next()) {
                do {
                    this.updateRecord(record, cursor, false);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void updateRecord(RelationshipGroupRecord record, PageCursor cursor, boolean force) {
        long id = record.getId();
        cursor.setOffset(this.offsetForId(id));
        if (record.inUse() || force) {
            long nextMod = record.getNext() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getNext() & 0x700000000L) >> 31;
            long nextOutMod = record.getFirstOut() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstOut() & 0x700000000L) >> 28;
            long nextInMod = record.getFirstIn() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstIn() & 0x700000000L) >> 31;
            long nextLoopMod = record.getFirstLoop() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (record.getFirstLoop() & 0x700000000L) >> 28;
            cursor.putByte((byte)(nextOutMod | nextMod | 1L));
            cursor.putByte((byte)(nextLoopMod | nextInMod));
            cursor.putShort((short)record.getType());
            cursor.putInt((int)record.getNext());
            cursor.putInt((int)record.getFirstOut());
            cursor.putInt((int)record.getFirstIn());
            cursor.putInt((int)record.getFirstLoop());
            cursor.putInt((int)record.getOwningNode());
            cursor.putByte((byte)(record.getOwningNode() >> 32));
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
            this.freeId(id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RelationshipGroupRecord forceGetRecord(long id) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(id), 1);){
            if (cursor.next()) {
                RelationshipGroupRecord record;
                do {
                    record = this.getRecord(id, cursor);
                } while (cursor.shouldRetry());
                if (record != null) {
                    RelationshipGroupRecord relationshipGroupRecord2 = record;
                    return relationshipGroupRecord2;
                }
            }
            RelationshipGroupRecord relationshipGroupRecord = new RelationshipGroupRecord(id, -1);
            return relationshipGroupRecord;
        }
        catch (IOException e) {
            return new RelationshipGroupRecord(id, -1);
        }
    }

    @Override
    public RelationshipGroupRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    @Override
    public void forceUpdateRecord(RelationshipGroupRecord record) {
        try (PageCursor cursor = this.storeFile.io(this.pageIdForRecord(record.getId()), 2);){
            if (cursor.next()) {
                do {
                    this.updateRecord(record, cursor, true);
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public RelationshipGroupRecord forceGetRaw(RelationshipGroupRecord record) {
        return record;
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RelationshipGroupRecord record) throws FAILURE {
        processor.processRelationshipGroup(this, record);
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 25;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public int getDenseNodeThreshold() {
        return this.denseNodeThreshold;
    }

    private int getUnsignedShort(short value) {
        return value & 0xFFFF;
    }
}

