/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreExpandCursor;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;

public class CacheLayer
implements StoreReadLayer {
    private static final Function<? super SchemaRule, IndexDescriptor> TO_INDEX_RULE = new Function<SchemaRule, IndexDescriptor>(){

        public IndexDescriptor apply(SchemaRule from) {
            IndexRule rule = (IndexRule)from;
            return new IndexDescriptor(rule.getLabel(), rule.getPropertyKey());
        }
    };
    public static final String EXPERIMENTAL_OFF = "experimental-off";
    private final CacheLoader<Iterator<DefinedProperty>> nodePropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(long id) throws EntityNotFoundException {
            return CacheLayer.this.diskLayer.nodeGetAllProperties(id);
        }
    };
    private final CacheLoader<Iterator<DefinedProperty>> relationshipPropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(long id) throws EntityNotFoundException {
            return CacheLayer.this.diskLayer.relationshipGetAllProperties(id);
        }
    };
    private final CacheLoader<Iterator<DefinedProperty>> graphPropertyLoader = new CacheLoader<Iterator<DefinedProperty>>(){

        @Override
        public Iterator<DefinedProperty> load(long id) throws EntityNotFoundException {
            return CacheLayer.this.diskLayer.graphGetAllProperties();
        }
    };
    private final CacheLoader<int[]> nodeLabelLoader = new CacheLoader<int[]>(){

        @Override
        public int[] load(long id) throws EntityNotFoundException {
            return PrimitiveIntCollections.asArray((PrimitiveIntIterator)CacheLayer.this.diskLayer.nodeGetLabels(id));
        }
    };
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final DiskLayer diskLayer;
    private final IndexingService indexingService;

    public CacheLayer(DiskLayer diskLayer, PersistenceCache persistenceCache, IndexingService indexingService, SchemaCache schemaCache) {
        this.diskLayer = diskLayer;
        this.persistenceCache = persistenceCache;
        this.indexingService = indexingService;
        this.schemaCache = schemaCache;
    }

    @Override
    public boolean nodeExists(long nodeId) {
        return this.diskLayer.nodeExists(nodeId);
    }

    @Override
    public boolean nodeHasLabel(long nodeId, int labelId) throws EntityNotFoundException {
        return this.persistenceCache.nodeHasLabel(nodeId, labelId, this.nodeLabelLoader);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(long nodeId) throws EntityNotFoundException {
        return PrimitiveIntCollections.iterator((int[])this.persistenceCache.nodeGetLabels(nodeId, this.nodeLabelLoader));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    private static Iterator<IndexDescriptor> toIndexDescriptors(Iterable<SchemaRule> rules, final SchemaRule.Kind kind) {
        Iterator<SchemaRule> filteredRules = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule item) {
                return item.getKind() == kind;
            }
        }, rules.iterator());
        return Iterables.map(TO_INDEX_RULE, filteredRules);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index, SchemaStorage.IndexRuleKind.ALL);
        if (rule != null) {
            return rule.getOwningConstraint();
        }
        return this.diskLayer.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index, kind);
        if (rule != null) {
            return rule.getId();
        }
        return this.diskLayer.indexGetCommittedId(index, kind);
    }

    @Override
    public IndexRule indexRule(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) {
        for (SchemaRule rule : this.schemaCache.schemaRulesForLabel(index.getLabelId())) {
            IndexRule indexRule;
            if (!(rule instanceof IndexRule) || !kind.isOfKind(indexRule = (IndexRule)rule) || indexRule.getPropertyKey() != index.getPropertyKeyId()) continue;
            return indexRule;
        }
        return null;
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetPropertyKeys(nodeId, this.nodePropertyLoader);
    }

    @Override
    public Property nodeGetProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetProperty(nodeId, propertyKeyId, this.nodePropertyLoader);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetProperties(nodeId, this.nodePropertyLoader);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(long relationshipId) throws EntityNotFoundException {
        return new PropertyKeyIdIterator(this.relationshipGetAllProperties(relationshipId));
    }

    @Override
    public Property relationshipGetProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        return this.persistenceCache.relationshipGetProperty(relationshipId, propertyKeyId, this.relationshipPropertyLoader);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.relationshipGetProperties(nodeId, this.relationshipPropertyLoader);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        return this.persistenceCache.graphGetPropertyKeys(this.graphPropertyLoader);
    }

    @Override
    public Property graphGetProperty(int propertyKeyId) {
        return this.persistenceCache.graphGetProperty(this.graphPropertyLoader, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties() {
        return this.persistenceCache.graphGetProperties(this.graphPropertyLoader);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(int labelId, int propertyKeyId) {
        return this.schemaCache.constraintsForLabelAndProperty(labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        return this.schemaCache.constraints();
    }

    @Override
    public PrimitiveLongResourceIterator nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        return this.diskLayer.nodeGetUniqueFromIndexLookup(state, this.schemaCache.indexId(index), value);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return this.diskLayer.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongResourceIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.diskLayer.nodesGetFromIndexLookup(state, this.schemaCache.indexId(index), value);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(int labelId, int propertyKey) {
        return this.schemaCache.indexDescriptor(labelId, propertyKey);
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexingService.getIndexProxy(this.schemaCache.indexId(descriptor)).getState();
    }

    @Override
    public double indexUniqueValuesPercentage(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexingService.indexUniqueValuesPercentage(this.schemaCache.indexId(descriptor));
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexGetFailure(descriptor);
    }

    @Override
    public int labelGetForName(String labelName) {
        return this.diskLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        return this.diskLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(String propertyKeyName) {
        return this.diskLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKeyName) {
        return this.diskLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.diskLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.diskLayer.propertyKeyGetAllTokens();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.diskLayer.labelsGetAllTokens();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.diskLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.diskLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(String labelName) throws TooManyLabelsException {
        return this.diskLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.diskLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    @Override
    public PrimitiveLongIterator nodeListRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetRelationships(nodeId, direction);
    }

    @Override
    public PrimitiveLongIterator nodeListRelationships(long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetRelationships(nodeId, direction, relTypes);
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetDegree(nodeId, direction);
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetDegree(nodeId, relType, direction);
    }

    @Override
    public boolean nodeVisitDegrees(long nodeId, DegreeVisitor visitor) {
        return this.persistenceCache.nodeVisitDegrees(nodeId, visitor);
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(long nodeId) throws EntityNotFoundException {
        return this.persistenceCache.nodeGetRelationshipTypes(nodeId);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        RelationshipImpl relationship = this.persistenceCache.getRelationship(relationshipId);
        relationshipVisitor.visit(relationshipId, relationship.getTypeId(), relationship.getStartNodeId(), relationship.getEndNodeId());
    }

    @Override
    public Cursor expand(Cursor inputCursor, NeoRegister.Node.In nodeId, Register.Object.In<int[]> types, Register.Object.In<Direction> expandDirection, NeoRegister.Relationship.Out relId, NeoRegister.RelType.Out relType, Register.Object.Out<Direction> direction, NeoRegister.Node.Out startNodeId, NeoRegister.Node.Out neighborNodeId) {
        return new StoreExpandCursor(this, inputCursor, nodeId, types, expandDirection, relId, relType, direction, startNodeId, neighborNodeId);
    }

    @Override
    public long countsForNode(int labelId) {
        return this.diskLayer.countsForNode(labelId);
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        return this.diskLayer.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    @Override
    public long highestNodeIdInUse() {
        return this.diskLayer.highestNodeIdInUse();
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        return this.diskLayer.nodesGetAll();
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll() {
        return this.diskLayer.relationshipsGetAll();
    }

    @Override
    public boolean relationshipExists(long relationshipId) {
        return this.diskLayer.relationshipExists(relationshipId);
    }

    @Override
    public long reserveNode() {
        return this.diskLayer.reserveNode();
    }

    @Override
    public long reserveRelationship() {
        return this.diskLayer.reserveRelationship();
    }

    @Override
    public void releaseNode(long id) {
        this.diskLayer.releaseNode(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.diskLayer.releaseRelationship(id);
    }
}

