/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.helpers.Clock;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class MultiExecutionMonitor
implements ExecutionMonitor {
    private final Clock clock;
    private final ExecutionMonitor[] monitors;
    private final long[] endTimes;

    public MultiExecutionMonitor(ExecutionMonitor ... monitors) {
        this(Clock.SYSTEM_CLOCK, monitors);
    }

    public MultiExecutionMonitor(Clock clock, ExecutionMonitor ... monitors) {
        this.clock = clock;
        this.monitors = monitors;
        this.endTimes = new long[monitors.length];
        this.fillEndTimes();
    }

    @Override
    public void start(StageExecution[] executions) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.start(executions);
        }
    }

    @Override
    public void end(StageExecution[] executions, long totalTimeMillis) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.end(executions, totalTimeMillis);
        }
    }

    @Override
    public void done(long totalTimeMillis) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.done(totalTimeMillis);
        }
    }

    @Override
    public long nextCheckTime() {
        long low = this.endTimes[0];
        for (int i = 1; i < this.monitors.length; ++i) {
            long thisLow = this.endTimes[i];
            if (thisLow >= low) continue;
            low = thisLow;
        }
        return low;
    }

    private void fillEndTimes() {
        for (int i = 0; i < this.monitors.length; ++i) {
            this.endTimes[i] = this.monitors[i].nextCheckTime();
        }
    }

    @Override
    public void check(StageExecution[] executions) {
        long currentTimeMillis = this.clock.currentTimeMillis();
        for (int i = 0; i < this.monitors.length; ++i) {
            if (currentTimeMillis < this.endTimes[i]) continue;
            this.monitors[i].check(executions);
            this.endTimes[i] = this.monitors[i].nextCheckTime();
        }
    }
}

