/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.function.Function;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.DataException;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputGroupsDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputNodeDeserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputRelationshipDeserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class CsvInput
implements Input {
    private final Iterable<DataFactory<InputNode>> nodeDataFactory;
    private final Header.Factory nodeHeaderFactory;
    private final Iterable<DataFactory<InputRelationship>> relationshipDataFactory;
    private final Header.Factory relationshipHeaderFactory;
    private final IdType idType;
    private final Configuration config;
    private final Groups groups = new Groups();
    private final Function<OutputStream, Collector<InputRelationship>> collectorFactory;

    public CsvInput(Iterable<DataFactory<InputNode>> nodeDataFactory, Header.Factory nodeHeaderFactory, Iterable<DataFactory<InputRelationship>> relationshipDataFactory, Header.Factory relationshipHeaderFactory, IdType idType, Configuration config, Function<OutputStream, Collector<InputRelationship>> collectorFactory) {
        this.assertSaneConfiguration(config);
        this.nodeDataFactory = nodeDataFactory;
        this.nodeHeaderFactory = nodeHeaderFactory;
        this.relationshipDataFactory = relationshipDataFactory;
        this.relationshipHeaderFactory = relationshipHeaderFactory;
        this.idType = idType;
        this.config = config;
        this.collectorFactory = collectorFactory;
    }

    private void assertSaneConfiguration(Configuration config) {
        HashMap<Character, String> delimiters = new HashMap<Character, String>();
        delimiters.put(Character.valueOf(config.delimiter()), "delimiter");
        this.checkUniqueCharacter(delimiters, config.arrayDelimiter(), "array delimiter");
        this.checkUniqueCharacter(delimiters, config.quotationCharacter(), "quotation character");
    }

    private void checkUniqueCharacter(Map<Character, String> characters, char character, String characterDescription) {
        String conflict = characters.put(Character.valueOf(character), characterDescription);
        if (conflict != null) {
            throw new IllegalArgumentException("Character '" + character + "' specified by " + characterDescription + " is the same as specified by " + conflict);
        }
    }

    @Override
    public InputIterable<InputNode> nodes() {
        return new InputIterable<InputNode>(){

            @Override
            public InputIterator<InputNode> iterator() {
                return new InputGroupsDeserializer<InputNode>(CsvInput.this.nodeDataFactory.iterator(), CsvInput.this.nodeHeaderFactory, CsvInput.this.config, CsvInput.this.idType){

                    @Override
                    protected InputEntityDeserializer<InputNode> entityDeserializer(CharSeeker dataStream, Header dataHeader, Function<InputNode, InputNode> decorator) {
                        return new InputEntityDeserializer<InputNode>(dataHeader, dataStream, CsvInput.this.config.delimiter(), new InputNodeDeserialization((SourceTraceability)dataStream, dataHeader, CsvInput.this.groups, CsvInput.this.idType.idsAreExternal()), decorator, Validators.emptyValidator());
                    }
                };
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public InputIterable<InputRelationship> relationships() {
        return new InputIterable<InputRelationship>(){

            @Override
            public InputIterator<InputRelationship> iterator() {
                return new InputGroupsDeserializer<InputRelationship>(CsvInput.this.relationshipDataFactory.iterator(), CsvInput.this.relationshipHeaderFactory, CsvInput.this.config, CsvInput.this.idType){

                    @Override
                    protected InputEntityDeserializer<InputRelationship> entityDeserializer(CharSeeker dataStream, Header dataHeader, Function<InputRelationship, InputRelationship> decorator) {
                        return new InputEntityDeserializer<InputRelationship>(dataHeader, dataStream, CsvInput.this.config.delimiter(), new InputRelationshipDeserialization((SourceTraceability)dataStream, dataHeader, CsvInput.this.groups), decorator, new Validator<InputRelationship>(){

                            @Override
                            public void validate(InputRelationship entity) {
                                if (!entity.hasTypeId() && entity.type() == null) {
                                    throw new DataException(entity + " is missing " + (Object)((Object)Type.TYPE) + " field");
                                }
                            }
                        });
                    }
                };
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public IdMapper idMapper() {
        return this.idType.idMapper();
    }

    @Override
    public IdGenerator idGenerator() {
        return this.idType.idGenerator();
    }

    @Override
    public boolean specificRelationshipIds() {
        return false;
    }

    @Override
    public Collector<InputRelationship> badRelationshipsCollector(OutputStream out) {
        return (Collector)this.collectorFactory.apply((Object)out);
    }
}

