/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadNodeRecordsStep
extends IoProducerStep {
    private final NodeStore nodeStore;
    private final long highId;
    private long id;

    public ReadNodeRecordsStep(StageControl control, Configuration config, NodeStore nodeStore) {
        super(control, config);
        this.nodeStore = nodeStore;
        this.highId = nodeStore.getHighId();
    }

    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize) {
        int size = (int)Math.min((long)batchSize, this.highId - this.id);
        NodeRecord[] batch = new NodeRecord[size];
        for (int i = 0; i < size; ++i) {
            batch[i] = this.nodeStore.loadRecord(this.id++, null);
        }
        return size > 0 ? batch : null;
    }

    @Override
    protected long position() {
        return this.id * 15L;
    }
}

