/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Arrays;

public class LabelChangeSummary {
    private static final long[] NO_LABELS = new long[0];
    private final long[] addedLabels;
    private final long[] removedLabels;
    private final long[] unchangedLabels;

    public LabelChangeSummary(long[] labelsBefore, long[] labelsAfter) {
        long[] addedLabels = new long[labelsAfter.length];
        long[] removedLabels = new long[labelsBefore.length];
        long[] unchangedLabels = new long[Math.min(addedLabels.length, removedLabels.length)];
        int addedLabelsCursor = 0;
        int removedLabelsCursor = 0;
        int unchangedLabelsCursor = 0;
        for (long labelAfter : labelsAfter) {
            if (Arrays.binarySearch(labelsBefore, labelAfter) < 0) {
                addedLabels[addedLabelsCursor++] = labelAfter;
                continue;
            }
            unchangedLabels[unchangedLabelsCursor++] = labelAfter;
        }
        for (long labelBefore : labelsBefore) {
            if (Arrays.binarySearch(labelsAfter, labelBefore) >= 0) continue;
            removedLabels[removedLabelsCursor++] = labelBefore;
        }
        this.addedLabels = this.shrink(addedLabels, addedLabelsCursor);
        this.removedLabels = this.shrink(removedLabels, removedLabelsCursor);
        this.unchangedLabels = this.shrink(unchangedLabels, unchangedLabelsCursor);
    }

    private long[] shrink(long[] array, int toLength) {
        if (toLength == 0) {
            return NO_LABELS;
        }
        return array.length == toLength ? array : Arrays.copyOf(array, toLength);
    }

    public boolean hasAddedLabels() {
        return this.addedLabels.length > 0;
    }

    public boolean hasRemovedLabels() {
        return this.removedLabels.length > 0;
    }

    public boolean hasUnchangedLabels() {
        return this.unchangedLabels.length > 0;
    }

    public long[] getAddedLabels() {
        return this.addedLabels;
    }

    public long[] getRemovedLabels() {
        return this.removedLabels;
    }

    public long[] getUnchangedLabels() {
        return this.unchangedLabels;
    }
}

