/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.CommandApplierFacade;
import org.neo4j.kernel.impl.api.CountsStoreApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.CacheInvalidationTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.HighIdTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.function.Optional;

public class TransactionRepresentationStoreApplier {
    private final NeoStore neoStore;
    private final IndexingService indexingService;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;
    private final LabelScanStore labelScanStore;
    private final IndexConfigStore indexConfigStore;
    private final LegacyIndexApplier.ProviderLookup legacyIndexProviderLookup;
    private final IdOrderingQueue legacyIndexTransactionOrdering;

    public TransactionRepresentationStoreApplier(IndexingService indexingService, LabelScanStore labelScanStore, NeoStore neoStore, CacheAccessBackDoor cacheAccess, LockService lockService, LegacyIndexApplier.ProviderLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore, IdOrderingQueue legacyIndexTransactionOrdering) {
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.neoStore = neoStore;
        this.cacheAccess = cacheAccess;
        this.lockService = lockService;
        this.legacyIndexProviderLookup = legacyIndexProviderLookup;
        this.indexConfigStore = indexConfigStore;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
    }

    public void apply(TransactionRepresentation representation, ValidatedIndexUpdates indexUpdates, LockGroup locks, long transactionId, TransactionApplicationMode mode) throws IOException {
        NeoCommandHandler storeApplier = new NeoStoreTransactionApplier(this.neoStore, this.cacheAccess, this.lockService, locks, transactionId);
        if (mode.needsIdTracking()) {
            storeApplier = new HighIdTransactionApplier(storeApplier, this.neoStore);
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            storeApplier = new CacheInvalidationTransactionApplier(storeApplier, this.neoStore, this.cacheAccess);
        }
        IndexTransactionApplier indexApplier = new IndexTransactionApplier(this.indexingService, indexUpdates, this.labelScanStore, this.cacheAccess);
        LegacyIndexApplier legacyIndexApplier = new LegacyIndexApplier(this.indexConfigStore, this.legacyIndexProviderLookup, this.legacyIndexTransactionOrdering, transactionId, mode);
        NeoCommandHandler countsStoreApplier = this.getCountsStoreApplier(transactionId, mode);
        try (CommandApplierFacade applier = new CommandApplierFacade(storeApplier, indexApplier, legacyIndexApplier, countsStoreApplier);){
            representation.accept(applier);
        }
    }

    private NeoCommandHandler getCountsStoreApplier(long transactionId, TransactionApplicationMode mode) {
        Optional<NeoCommandHandler> handlerOption = this.neoStore.getCounts().apply(transactionId).map(CountsStoreApplier.FACTORY);
        if (mode == TransactionApplicationMode.RECOVERY) {
            handlerOption = handlerOption.or(NeoCommandHandler.EMPTY);
        }
        return handlerOption.get();
    }

    public TransactionRepresentationStoreApplier withLegacyIndexTransactionOrdering(IdOrderingQueue legacyIndexTransactionOrdering) {
        return new TransactionRepresentationStoreApplier(this.indexingService, this.labelScanStore, this.neoStore, this.cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, legacyIndexTransactionOrdering);
    }
}

