/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;

public class TransactionRepresentationCommitProcess
implements TransactionCommitProcess {
    private final LogicalTransactionStore logicalTransactionStore;
    private final KernelHealth kernelHealth;
    private final TransactionIdStore transactionIdStore;
    private final TransactionRepresentationStoreApplier storeApplier;
    private final IndexUpdatesValidator indexUpdatesValidator;
    private final TransactionApplicationMode mode;

    public TransactionRepresentationCommitProcess(LogicalTransactionStore logicalTransactionStore, KernelHealth kernelHealth, TransactionIdStore transactionIdStore, TransactionRepresentationStoreApplier storeApplier, IndexUpdatesValidator indexUpdatesValidator, TransactionApplicationMode mode) {
        this.logicalTransactionStore = logicalTransactionStore;
        this.transactionIdStore = transactionIdStore;
        this.kernelHealth = kernelHealth;
        this.storeApplier = storeApplier;
        this.indexUpdatesValidator = indexUpdatesValidator;
        this.mode = mode;
    }

    @Override
    public long commit(TransactionRepresentation transaction, LockGroup locks, CommitEvent commitEvent) throws TransactionFailureException {
        try (ValidatedIndexUpdates indexUpdates = this.validateIndexUpdates(transaction);){
            long transactionId = this.commitTransaction(transaction, commitEvent);
            commitEvent.setTransactionId(transactionId);
            try (StoreApplyEvent storeApplyEvent = commitEvent.beginStoreApply();){
                this.storeApplier.apply(transaction, indexUpdates, locks, transactionId, this.mode);
            }
            catch (Throwable e) {
                throw this.exception(Status.Transaction.CouldNotCommit, e, "Could not apply the transaction to the store after written to log");
            }
            finally {
                this.transactionIdStore.transactionClosed(transactionId);
            }
            long l = transactionId;
            return l;
        }
    }

    private TransactionFailureException exception(Status status, Throwable cause, String message) {
        this.kernelHealth.panic(cause);
        return new TransactionFailureException(status, cause, message, new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long commitTransaction(TransactionRepresentation tx, CommitEvent commitEvent) throws TransactionFailureException {
        try (LogAppendEvent logAppendEvent = commitEvent.beginLogAppend();){
            long l = this.logicalTransactionStore.getAppender().append(tx, logAppendEvent);
            return l;
        }
        catch (Throwable e) {
            throw this.exception(Status.Transaction.CouldNotWriteToLog, e, "Could not append transaction representation to log");
        }
    }

    private ValidatedIndexUpdates validateIndexUpdates(TransactionRepresentation transaction) throws TransactionFailureException {
        try {
            return this.indexUpdatesValidator.validate(transaction, this.mode);
        }
        catch (Throwable e) {
            throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, e, "Validation of index updates failed", new Object[0]);
        }
    }
}

