/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdGeneratorFactory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.BatchingWindowPoolFactory;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class BatchingNeoStore
implements AutoCloseable {
    private final FileSystemAbstraction fileSystem;
    private final NeoStore neoStore;
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyRepository;
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelRepository;
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private final StringLogger logger;
    private final Config neo4jConfig;
    private final File neoStoreFileName;
    private final BatchingWindowPoolFactory pageCacheFactory;
    private final BatchingWindowPoolFactory.WriterFactory writerFactory;

    public BatchingNeoStore(FileSystemAbstraction fileSystem, String storeDir, Configuration config, Monitor writeMonitor, Logging logging, BatchingWindowPoolFactory.WriterFactory writerFactory) {
        this.fileSystem = fileSystem;
        this.writerFactory = writerFactory;
        this.neoStoreFileName = new File(storeDir, "neostore");
        this.logger = logging.getMessagesLog(this.getClass());
        this.neo4jConfig = StoreFactory.configForStoreDir(new Config(MapUtil.stringMap(GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(config.denseNodeThreshold()))), new File(storeDir));
        this.pageCacheFactory = new BatchingWindowPoolFactory(config.fileChannelBufferSize(), writeMonitor, BatchingWindowPoolFactory.Mode.APPEND_ONLY, writerFactory);
        this.neoStore = this.newNeoStore(this.pageCacheFactory);
        this.flushNeoStoreAndAwaitEverythingWritten();
        this.propertyKeyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository(this.neoStore.getPropertyKeyTokenStore());
        this.labelRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.neoStore.getLabelTokenStore());
        this.relationshipTypeRepository = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(this.neoStore.getRelationshipTypeStore());
    }

    private NeoStore newNeoStore(WindowPoolFactory windowPoolFactory) {
        StoreFactory storeFactory = new StoreFactory(this.neo4jConfig, new BatchingIdGeneratorFactory(), windowPoolFactory, this.fileSystem, this.logger, new DefaultTxHook());
        if (this.fileSystem.fileExists(this.neoStoreFileName)) {
            return storeFactory.newNeoStore(this.neoStoreFileName);
        }
        return storeFactory.createNeoStore(this.neoStoreFileName);
    }

    public NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    public BatchingTokenRepository<?> getPropertyKeyRepository() {
        return this.propertyKeyRepository;
    }

    public BatchingTokenRepository<?> getLabelRepository() {
        return this.labelRepository;
    }

    public BatchingTokenRepository<?> getRelationshipTypeRepository() {
        return this.relationshipTypeRepository;
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.neoStore.getRelationshipGroupStore();
    }

    public void switchToUpdateMode() {
        this.pageCacheFactory.setMode(BatchingWindowPoolFactory.Mode.UPDATE);
    }

    @Override
    public void close() {
        this.propertyKeyRepository.close();
        this.labelRepository.close();
        this.relationshipTypeRepository.close();
        this.flushNeoStoreAndAwaitEverythingWritten();
        this.neoStore.close();
    }

    private void flushNeoStoreAndAwaitEverythingWritten() {
        this.neoStore.flushAll();
        this.writerFactory.awaitEverythingWritten();
    }
}

