/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class StageExecution
implements StageControl {
    private final String stageName;
    private final Configuration config;
    private final Iterable<Step<?>> pipeline;
    private final StringLogger logger;
    private volatile Throwable panicCause;
    private long startTime;

    public StageExecution(Logging logging, String stageName, Configuration config, Iterable<Step<?>> pipeline) {
        this.stageName = stageName;
        this.config = config;
        this.pipeline = pipeline;
        this.logger = logging.getMessagesLog(this.getClass());
    }

    public boolean stillExecuting() {
        if (this.panicCause != null) {
            throw new RuntimeException("Panic", this.panicCause);
        }
        for (Step<?> step : this.pipeline) {
            if (step.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public long getExecutionTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public String getStageName() {
        return this.stageName;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Iterable<StepStats> stats() {
        return new IterableWrapper<StepStats, Step<?>>(this.pipeline){

            @Override
            protected StepStats underlyingObjectToObject(Step<?> step) {
                return step.stats();
            }
        };
    }

    @Override
    public void panic(Throwable cause) {
        cause.printStackTrace();
        this.logger.error("Panic", cause);
        this.panicCause = cause;
        for (Step<?> step : this.pipeline) {
            step.receivePanic(cause);
        }
    }
}

