/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArrayFactory;

public class DynamicLongArray
implements LongArray {
    private final LongArrayFactory factory;
    private final long chunkSize;
    private LongArray[] chunks = new LongArray[0];
    private Long setAllValue;

    public DynamicLongArray(LongArrayFactory factory, long chunkSize) {
        this.factory = factory;
        this.chunkSize = chunkSize;
    }

    @Override
    public long length() {
        return (long)this.chunks.length * this.chunkSize;
    }

    @Override
    public long get(long index) {
        int chunkIndex = this.chunkIndex(index);
        return chunkIndex < this.chunks.length ? this.chunks[chunkIndex].get(this.index(index)) : this.defaultValue();
    }

    private long defaultValue() {
        return this.setAllValue != null ? this.setAllValue : 0L;
    }

    @Override
    public void set(long index, long value) {
        while (index >= this.length()) {
            this.addChunk();
        }
        this.chunk(index).set(this.index(index), value);
    }

    private long index(long index) {
        return index % this.chunkSize;
    }

    private LongArray chunk(long index) {
        return this.chunks[this.chunkIndex(index)];
    }

    private int chunkIndex(long index) {
        return (int)(index / this.chunkSize);
    }

    private void addChunk() {
        this.chunks = Arrays.copyOf(this.chunks, this.chunks.length + 1);
        LongArray newLongArray = this.factory.newLongArray(this.chunkSize);
        if (this.setAllValue != null) {
            newLongArray.setAll(this.setAllValue);
        }
        this.chunks[this.chunks.length - 1] = newLongArray;
    }

    @Override
    public void setAll(long value) {
        for (LongArray chunk : this.chunks) {
            chunk.setAll(value);
        }
        this.setAllValue = value;
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        for (int i = 0; i < numberOfEntries; ++i) {
            long intermediary = this.get(fromIndex + (long)i);
            this.set(fromIndex + (long)i, this.get(toIndex + (long)i));
            this.set(toIndex + (long)i, intermediary);
        }
    }
}

