/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.io.IOException;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;

public class PositionCacheLogHandler
extends LogHandler.Filter {
    private LogEntry.Start startEntry;
    private final LogExtractor.LogPositionCache positionCache;
    private final SPI spi;

    public PositionCacheLogHandler(XaLogicalLog.LogApplier applier, LogExtractor.LogPositionCache positionCache, SPI spi) {
        super(applier);
        this.positionCache = positionCache;
        this.spi = spi;
    }

    @Override
    public void startEntry(LogEntry.Start startEntry) throws IOException {
        super.startEntry(startEntry);
        this.startEntry = startEntry;
    }

    @Override
    public void onePhaseCommitEntry(LogEntry.OnePhaseCommit onePhaseCommitEntry) throws IOException {
        super.onePhaseCommitEntry(onePhaseCommitEntry);
        assert (this.startEntry != null);
        this.positionCache.cacheStartPosition(onePhaseCommitEntry.getTxId(), this.startEntry, this.spi.getLogVersion());
        this.startEntry = null;
    }

    @Override
    public void twoPhaseCommitEntry(LogEntry.TwoPhaseCommit twoPhaseCommitEntry) throws IOException {
        super.twoPhaseCommitEntry(twoPhaseCommitEntry);
        assert (this.startEntry != null);
        this.positionCache.cacheStartPosition(twoPhaseCommitEntry.getTxId(), this.startEntry, this.spi.getLogVersion());
        this.startEntry = null;
    }

    public static interface SPI {
        public long getLogVersion();
    }
}

