/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class BridgingCacheAccess
implements CacheAccessBackDoor {
    private final NodeManager nodeManager;
    private final SchemaCache schemaCache;
    private final SchemaState schemaState;
    private final PersistenceCache persistenceCache;

    public BridgingCacheAccess(NodeManager nodeManager, SchemaCache schemaCache, SchemaState schemaState, PersistenceCache persistenceCache) {
        this.nodeManager = nodeManager;
        this.schemaCache = schemaCache;
        this.schemaState = schemaState;
        this.persistenceCache = persistenceCache;
    }

    @Override
    public void removeNodeFromCache(long nodeId) {
        if (nodeId != -1L) {
            this.nodeManager.removeNodeFromCache(nodeId);
            this.persistenceCache.evictNode(nodeId);
        }
    }

    @Override
    public void removeRelationshipFromCache(long id) {
        this.nodeManager.removeRelationshipFromCache(id);
    }

    @Override
    public void removeRelationshipTypeFromCache(int id) {
        this.nodeManager.removeRelationshipTypeFromCache(id);
    }

    @Override
    public void removePropertyKeyFromCache(int id) {
        this.nodeManager.removePropertyKeyFromCache(id);
    }

    @Override
    public void removeLabelFromCache(int id) {
        this.nodeManager.removeLabelFromCache(id);
    }

    @Override
    public void removeGraphPropertiesFromCache() {
        this.nodeManager.removeGraphPropertiesFromCache();
    }

    @Override
    public void addSchemaRule(SchemaRule rule) {
        this.schemaCache.addSchemaRule(rule);
    }

    @Override
    public void removeSchemaRuleFromCache(long id) {
        this.schemaCache.removeSchemaRule(id);
        this.schemaState.clear();
    }

    @Override
    public void addRelationshipTypeToken(Token type) {
        this.nodeManager.addRelationshipTypeToken(type);
    }

    @Override
    public void addLabelToken(Token label) {
        this.nodeManager.addLabelToken(label);
    }

    @Override
    public void addPropertyKeyToken(Token propertyKey) {
        this.nodeManager.addPropertyKeyToken(propertyKey);
    }

    @Override
    public void patchDeletedRelationshipNodes(long relId, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNodeNextRelId) {
        this.nodeManager.patchDeletedRelationshipNodes(relId, firstNodeId, firstNodeNextRelId, secondNodeId, secondNodeNextRelId);
    }

    @Override
    public void applyLabelUpdates(Collection<NodeLabelUpdate> labelUpdates) {
        this.persistenceCache.apply(labelUpdates);
    }
}

