/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.List;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class CalculateDenseNodesStep
extends ExecutorServiceStep<List<InputRelationship>> {
    private final NodeRelationshipLink nodeRelationshipLink;
    private long highestSeenNodeId;
    private StringLogger logger;

    public CalculateDenseNodesStep(StageControl control, int workAheadSize, NodeRelationshipLink nodeRelationshipLink, StringLogger logger) {
        super(control, "CALCULATOR", workAheadSize, 1);
        this.nodeRelationshipLink = nodeRelationshipLink;
        this.logger = logger;
    }

    @Override
    protected Object process(long ticket, List<InputRelationship> batch) {
        for (InputRelationship rel : batch) {
            try {
                this.nodeRelationshipLink.incrementCount(rel.startNode());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException("Input relationship " + rel + " refers to missing start node " + rel.startNode(), e);
            }
            if (!rel.isLoop()) {
                try {
                    this.nodeRelationshipLink.incrementCount(rel.endNode());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("Input relationship " + rel + " refers to missing end node " + rel.endNode(), e);
                }
            }
            this.highestSeenNodeId = Math.max(this.highestSeenNodeId, Math.max(rel.startNode(), rel.endNode()));
        }
        return null;
    }

    @Override
    protected void done() {
        long numberOfDenseNodes = 0L;
        for (long i = 0L; i < this.highestSeenNodeId; ++i) {
            if (!this.nodeRelationshipLink.isDense(i)) continue;
            ++numberOfDenseNodes;
        }
        this.logger.info("# dense nodes: " + numberOfDenseNodes + ", which is " + Math.round(100.0 * (double)numberOfDenseNodes / (double)this.highestSeenNodeId) + " %");
        super.done();
    }
}

