/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.kernel.impl.util.RelIdArray;

public class RelIdArrayWithLoops
extends RelIdArray {
    private RelIdArray.IdBlock loopBlock;

    public RelIdArrayWithLoops(int type) {
        super(type);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return super.sizeOfObjectInBytesIncludingOverhead() + RelIdArrayWithLoops.sizeOfBlockWithReference(this.loopBlock);
    }

    protected RelIdArrayWithLoops(RelIdArray from) {
        super(from);
        this.loopBlock = from.getLastLoopBlock();
    }

    protected RelIdArrayWithLoops(int type, RelIdArray.IdBlock out, RelIdArray.IdBlock in, RelIdArray.IdBlock loop) {
        super(type, out, in);
        this.loopBlock = loop;
    }

    @Override
    protected RelIdArray.IdBlock getLastLoopBlock() {
        return this.loopBlock;
    }

    @Override
    protected void setLastLoopBlock(RelIdArray.IdBlock block) {
        this.loopBlock = block;
    }

    @Override
    public RelIdArray upgradeIfNeeded(RelIdArray capabilitiesToMatch) {
        return this;
    }

    @Override
    public RelIdArray downgradeIfPossible() {
        return this.loopBlock == null ? new RelIdArray(this) : this;
    }

    @Override
    public RelIdArray newSimilarInstance() {
        return new RelIdArrayWithLoops(this.getType());
    }

    @Override
    protected boolean accepts(RelIdArray source) {
        return true;
    }
}

