/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v19;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogIoUtil;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class Legacy19LogIoUtil
implements LegacyLogIoUtil {
    private static final short LEGACY_FORMAT_VERSION = 2;
    private static final int LOG_HEADER_SIZE = 16;
    private final LegacyLogIoUtil.CommandReader commandReader;

    public Legacy19LogIoUtil(LegacyLogIoUtil.CommandReader commandReader) {
        this.commandReader = commandReader;
    }

    @Override
    public long[] readLogHeader(ByteBuffer buffer, ReadableByteChannel channel, boolean strict) throws IOException {
        buffer.clear();
        buffer.limit(16);
        if (channel.read(buffer) != 16) {
            if (strict) {
                throw new IOException("Unable to read log version and last committed tx");
            }
            return null;
        }
        buffer.flip();
        long version = buffer.getLong();
        long previousCommittedTx = buffer.getLong();
        long logFormatVersion = version >> 56 & 0xFFL;
        if (2L != logFormatVersion) {
            throw new IllegalLogFormatException(2L, logFormatVersion);
        }
        return new long[]{version &= 0xFFFFFFFFFFFFFFL, previousCommittedTx};
    }

    @Override
    public LogEntry readEntry(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        try {
            return this.readLogEntry(buffer, channel);
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    private LogEntry readLogEntry(ByteBuffer buffer, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        byte entry = this.readNextByte(buffer, channel);
        switch (entry) {
            case 1: {
                return this.readTxStartEntry(buffer, channel);
            }
            case 2: {
                return this.readTxPrepareEntry(buffer, channel);
            }
            case 5: {
                return this.readTxOnePhaseCommitEntry(buffer, channel);
            }
            case 6: {
                return this.readTxTwoPhaseCommitEntry(buffer, channel);
            }
            case 3: {
                return this.readTxCommandEntry(buffer, channel);
            }
            case 4: {
                return this.readTxDoneEntry(buffer, channel);
            }
            case 0: {
                return null;
            }
        }
        throw new IOException("Unknown entry[" + entry + "]");
    }

    private LogEntry.Start readTxStartEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        byte globalIdLength = this.readNextByte(buf, channel);
        byte branchIdLength = this.readNextByte(buf, channel);
        byte[] globalId = new byte[globalIdLength];
        this.readIntoBufferAndFlip(ByteBuffer.wrap(globalId), channel, globalIdLength);
        byte[] branchId = new byte[branchIdLength];
        this.readIntoBufferAndFlip(ByteBuffer.wrap(branchId), channel, branchIdLength);
        int identifier = this.readNextInt(buf, channel);
        int formatId = this.readNextInt(buf, channel);
        int masterId = this.readNextInt(buf, channel);
        int myId = this.readNextInt(buf, channel);
        long timeWritten = this.readNextLong(buf, channel);
        XidImpl xid = new XidImpl(globalId, branchId);
        return new LogEntry.Start(xid, identifier, masterId, myId, -1L, timeWritten, 0L);
    }

    private LogEntry.Prepare readTxPrepareEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Prepare(this.readNextInt(buf, channel), this.readNextLong(buf, channel));
    }

    private LogEntry.OnePhaseCommit readTxOnePhaseCommitEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.OnePhaseCommit(this.readNextInt(buf, channel), this.readNextLong(buf, channel), this.readNextLong(buf, channel));
    }

    private LogEntry.Done readTxDoneEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.Done(this.readNextInt(buf, channel));
    }

    private LogEntry.TwoPhaseCommit readTxTwoPhaseCommitEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return new LogEntry.TwoPhaseCommit(this.readNextInt(buf, channel), this.readNextLong(buf, channel), this.readNextLong(buf, channel));
    }

    private LogEntry.Command readTxCommandEntry(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        int identifier = this.readNextInt(buf, channel);
        XaCommand command = this.commandReader.readCommand(channel, buf);
        if (command == null) {
            return null;
        }
        return new LogEntry.Command(identifier, command);
    }

    private int readNextInt(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return this.readIntoBufferAndFlip(buf, channel, 4).getInt();
    }

    private long readNextLong(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return this.readIntoBufferAndFlip(buf, channel, 8).getLong();
    }

    private byte readNextByte(ByteBuffer buf, ReadableByteChannel channel) throws IOException, ReadPastEndException {
        return this.readIntoBufferAndFlip(buf, channel, 1).get();
    }

    private ByteBuffer readIntoBufferAndFlip(ByteBuffer buf, ReadableByteChannel channel, int numberOfBytes) throws IOException, ReadPastEndException {
        buf.clear();
        buf.limit(numberOfBytes);
        if (channel.read(buf) != buf.limit()) {
            throw new ReadPastEndException();
        }
        buf.flip();
        return buf;
    }
}

