/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultGraphDatabaseDependencies;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SystemOutLogging;

public class StoreMigrationTool {
    public static void main(String[] args) {
        String legacyStoreDirectory = args[0];
        new StoreMigrationTool().run(legacyStoreDirectory, new Config(), new SystemOutLogging(), StoreUpgrader.NO_MONITOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String legacyStoreDirectory, Config config, Logging logging, StoreUpgrader.Monitor monitor) {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        StoreUpgrader migrationProcess = new StoreUpgrader(new ConfigMapUpgradeConfiguration(config), fs, monitor);
        config = StoreFactory.configForStoreDir(config, new File(legacyStoreDirectory));
        migrationProcess.addParticipant(new StoreMigrator(new VisibleMigrationProgressMonitor(logging.getMessagesLog(StoreMigrationTool.class), System.out), new UpgradableDatabase(new StoreVersionCheck(fs)), config, logging));
        LifeSupport life = new LifeSupport();
        KernelExtensions kernelExtensions = life.add(new KernelExtensions(new DefaultGraphDatabaseDependencies().kernelExtensions(), config, this.kernelExtensionDependencyResolver(fs, config), UnsatisfiedDependencyStrategies.ignore()));
        life.start();
        try {
            SchemaIndexProvider schemaIndexProvider = kernelExtensions.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
            migrationProcess.addParticipant(schemaIndexProvider.storeMigrationParticipant());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            long startTime = System.currentTimeMillis();
            migrationProcess.migrateIfNeeded(new File(legacyStoreDirectory));
            long duration = System.currentTimeMillis() - startTime;
            logging.getMessagesLog(StoreMigrationTool.class).info(String.format("Migration completed in %d s%n", duration / 1000L));
        }
        finally {
            life.shutdown();
        }
    }

    private DependencyResolver kernelExtensionDependencyResolver(final FileSystemAbstraction fileSystem, final Config config) {
        return new DependencyResolver.Adapter(){

            @Override
            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (type.isInstance(fileSystem)) {
                    return type.cast(fileSystem);
                }
                if (type.isInstance(config)) {
                    return type.cast(config);
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }
}

