/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.NeoCommandVisitor;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class PhysicalLogNeoXaCommandReaderV0
implements XaCommandReader {
    private ByteBuffer scratch;
    private ReadableByteChannel byteChannel;

    public PhysicalLogNeoXaCommandReaderV0(ByteBuffer scratch) {
        this.scratch = scratch;
    }

    @Override
    public XaCommand read(ReadableByteChannel byteChannel) throws IOException {
        Command command;
        this.byteChannel = byteChannel;
        int commandType = 0;
        while (commandType == 0) {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, this.scratch, 1)) {
                return null;
            }
            commandType = this.scratch.get();
        }
        PhysicalNeoCommandReader reader = new PhysicalNeoCommandReader();
        switch (commandType) {
            case 1: {
                command = new Command.NodeCommand();
                break;
            }
            case 2: {
                command = new Command.PropertyCommand();
                break;
            }
            case 5: {
                command = new Command.PropertyKeyTokenCommand();
                break;
            }
            case 3: {
                command = new Command.RelationshipCommand();
                break;
            }
            case 4: {
                command = new Command.RelationshipTypeTokenCommand();
                break;
            }
            case 8: {
                command = new Command.LabelTokenCommand();
                break;
            }
            case 6: {
                command = new Command.NeoStoreCommand();
                break;
            }
            case 7: {
                command = new Command.SchemaRuleCommand();
                break;
            }
            case 0: {
                command = null;
                break;
            }
            default: {
                throw new IOException("Unknown command type[" + commandType + "]");
            }
        }
        if (command != null && !command.accept(reader)) {
            return null;
        }
        return command;
    }

    private class PhysicalNeoCommandReader
    implements NeoCommandVisitor {
        private final DynamicRecordAdder<PropertyBlock> PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyBlock>(){

            @Override
            public void add(PropertyBlock target, DynamicRecord record) {
                record.setCreated();
                target.addValueRecord(record);
            }
        };
        private final DynamicRecordAdder<Collection<DynamicRecord>> COLLECTION_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<Collection<DynamicRecord>>(){

            @Override
            public void add(Collection<DynamicRecord> target, DynamicRecord record) {
                target.add(record);
            }
        };
        private final DynamicRecordAdder<PropertyRecord> PROPERTY_DELETED_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyRecord>(){

            @Override
            public void add(PropertyRecord target, DynamicRecord record) {
                assert (!record.inUse()) : record + " is kinda weird";
                target.addDeletedRecord(record);
            }
        };
        private final DynamicRecordAdder<PropertyKeyTokenRecord> PROPERTY_INDEX_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyKeyTokenRecord>(){

            @Override
            public void add(PropertyKeyTokenRecord target, DynamicRecord record) {
                target.addNameRecord(record);
            }
        };

        private PhysicalNeoCommandReader() {
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 8)) {
                return false;
            }
            long id = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            NodeRecord before = this.readNodeRecord(id);
            if (before == null) {
                return false;
            }
            NodeRecord after = this.readNodeRecord(id);
            if (after == null) {
                return false;
            }
            if (!before.inUse() && after.inUse()) {
                after.setCreated();
            }
            command.init(before, after);
            return true;
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
            RelationshipRecord record;
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 9)) {
                return false;
            }
            long id = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            byte inUseFlag = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if ((inUseFlag & Record.IN_USE.byteValue()) != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            if (inUse) {
                if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 60)) {
                    return false;
                }
                record = new RelationshipRecord(id, PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong(), PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong(), PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt());
                record.setInUse(inUse);
                record.setFirstPrevRel(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
                record.setFirstNextRel(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
                record.setSecondPrevRel(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
                record.setSecondNextRel(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
                record.setNextProp(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
            } else {
                record = new RelationshipRecord(id, -1L, -1L, -1);
                record.setInUse(false);
            }
            command.init(record);
            return true;
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 8)) {
                return false;
            }
            long id = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            PropertyRecord before = this.readPropertyRecord(id);
            if (before == null) {
                return false;
            }
            PropertyRecord after = this.readPropertyRecord(id);
            if (after == null) {
                return false;
            }
            command.init(before, after);
            return true;
        }

        @Override
        public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
            boolean inUse;
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 51)) {
                return false;
            }
            long id = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            byte inUseByte = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            boolean bl = inUse = inUseByte == Record.IN_USE.byteValue();
            if (inUseByte != Record.IN_USE.byteValue() && inUseByte != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseByte);
            }
            short type = PhysicalLogNeoXaCommandReaderV0.this.scratch.getShort();
            RelationshipGroupRecord record = new RelationshipGroupRecord(id, type);
            record.setInUse(inUse);
            record.setNext(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
            record.setFirstOut(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
            record.setFirstIn(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
            record.setFirstLoop(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
            record.setOwningNode(PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
            command.init(record);
            return true;
        }

        @Override
        public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 13)) {
                return false;
            }
            int id = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
            byte inUseFlag = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
            record.setInUse(inUse);
            record.setNameId(PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt());
            int nrTypeRecords = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
            for (int i = 0; i < nrTypeRecords; ++i) {
                DynamicRecord dr = this.readDynamicRecord();
                if (dr == null) {
                    return false;
                }
                record.addNameRecord(dr);
            }
            command.init(record);
            return true;
        }

        @Override
        public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 13)) {
                return false;
            }
            int id = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
            byte inUseFlag = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            LabelTokenRecord record = new LabelTokenRecord(id);
            record.setInUse(inUse);
            record.setNameId(PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt());
            int nrTypeRecords = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
            for (int i = 0; i < nrTypeRecords; ++i) {
                DynamicRecord dr = this.readDynamicRecord();
                if (dr == null) {
                    return false;
                }
                record.addNameRecord(dr);
            }
            command.init(record);
            return true;
        }

        @Override
        public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 13)) {
                return false;
            }
            int id = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
            byte inUseFlag = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
            record.setInUse(inUse);
            record.setPropertyCount(PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt());
            record.setNameId(PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt());
            if (!this.readDynamicRecords(record, this.PROPERTY_INDEX_DYNAMIC_RECORD_ADDER)) {
                return false;
            }
            command.init(record);
            return true;
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            ArrayList<DynamicRecord> recordsBefore = new ArrayList<DynamicRecord>();
            this.readDynamicRecords(recordsBefore, this.COLLECTION_DYNAMIC_RECORD_ADDER);
            ArrayList<DynamicRecord> recordsAfter = new ArrayList<DynamicRecord>();
            this.readDynamicRecords(recordsAfter, this.COLLECTION_DYNAMIC_RECORD_ADDER);
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 1)) {
                return false;
            }
            byte isCreated = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            if (1 == isCreated) {
                for (DynamicRecord record : recordsAfter) {
                    record.setCreated();
                }
            }
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 8)) {
                return false;
            }
            long txId = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            SchemaRule rule = ((DynamicRecord)IteratorUtil.first(recordsAfter)).inUse() ? this.readSchemaRule(recordsAfter) : this.readSchemaRule(recordsBefore);
            command.init(recordsBefore, recordsAfter, rule, txId);
            return true;
        }

        @Override
        public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 8)) {
                return false;
            }
            long nextProp = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            NeoStoreRecord record = new NeoStoreRecord();
            record.setNextProp(nextProp);
            command.init(record);
            return true;
        }

        private NodeRecord readNodeRecord(long id) throws IOException {
            NodeRecord record;
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 1)) {
                return null;
            }
            byte inUseFlag = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            boolean inUse = false;
            if (inUseFlag == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            if (inUse) {
                if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 24)) {
                    return null;
                }
                record = new NodeRecord(id, false, PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong(), PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong());
                long labelField = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
                ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
                this.readDynamicRecords(dynamicLabelRecords, this.COLLECTION_DYNAMIC_RECORD_ADDER);
                record.setLabelField(labelField, dynamicLabelRecords);
            } else {
                record = new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
            }
            record.setInUse(inUse);
            return record;
        }

        DynamicRecord readDynamicRecord() throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 13)) {
                return null;
            }
            long id = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
            int type = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
            byte inUseFlag = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
            DynamicRecord record = new DynamicRecord(id);
            record.setInUse(inUse, type);
            if (inUse) {
                record.setStartRecord((inUseFlag & Record.FIRST_IN_CHAIN.byteValue()) != 0);
                if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 12)) {
                    return null;
                }
                int nrOfBytes = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
                assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
                long nextBlock = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
                assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
                record.setNextBlock(nextBlock);
                if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, nrOfBytes)) {
                    return null;
                }
                byte[] data = new byte[nrOfBytes];
                PhysicalLogNeoXaCommandReaderV0.this.scratch.get(data);
                record.setData(data);
            }
            return record;
        }

        <T> boolean readDynamicRecords(T target, DynamicRecordAdder<T> adder) throws IOException {
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 4)) {
                return false;
            }
            int numberOfRecords = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
            assert (numberOfRecords >= 0);
            while (numberOfRecords-- > 0) {
                DynamicRecord read = this.readDynamicRecord();
                if (read == null) {
                    return false;
                }
                adder.add(target, read);
            }
            return true;
        }

        private PropertyRecord readPropertyRecord(long id) throws IOException {
            long primitiveId;
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 25)) {
                return null;
            }
            PropertyRecord record = new PropertyRecord(id);
            byte inUseFlag = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            long nextProp = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            long prevProp = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            record.setNextProp(nextProp);
            record.setPrevProp(prevProp);
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            }
            boolean nodeProperty = true;
            if ((inUseFlag & Record.REL_PROPERTY.byteValue()) == Record.REL_PROPERTY.byteValue()) {
                nodeProperty = false;
            }
            if ((primitiveId = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong()) != -1L && nodeProperty) {
                record.setNodeId(primitiveId);
            } else if (primitiveId != -1L) {
                record.setRelId(primitiveId);
            }
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 1)) {
                return null;
            }
            int nrPropBlocks = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            assert (nrPropBlocks >= 0);
            if (nrPropBlocks > 0) {
                record.setInUse(true);
            }
            while (nrPropBlocks-- > 0) {
                PropertyBlock block = this.readPropertyBlock();
                if (block == null) {
                    return null;
                }
                record.addPropertyBlock(block);
            }
            if (!this.readDynamicRecords(record, this.PROPERTY_DELETED_DYNAMIC_RECORD_ADDER)) {
                return null;
            }
            PhysicalLogNeoXaCommandReaderV0.this.scratch.flip();
            int deletedRecords = PhysicalLogNeoXaCommandReaderV0.this.scratch.getInt();
            assert (deletedRecords >= 0);
            while (deletedRecords-- > 0) {
                DynamicRecord read = this.readDynamicRecord();
                if (read == null) {
                    return null;
                }
                record.addDeletedRecord(read);
            }
            if (inUse && !record.inUse() || !inUse && record.inUse()) {
                throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
            }
            return record;
        }

        PropertyBlock readPropertyBlock() throws IOException {
            PropertyBlock toReturn = new PropertyBlock();
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, 1)) {
                return null;
            }
            byte blockSize = PhysicalLogNeoXaCommandReaderV0.this.scratch.get();
            assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
            if (!IoPrimitiveUtils.readAndFlip(PhysicalLogNeoXaCommandReaderV0.this.byteChannel, PhysicalLogNeoXaCommandReaderV0.this.scratch, blockSize)) {
                return null;
            }
            long[] blocks = this.readLongs(blockSize / 8);
            assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
            assert (PropertyType.getPropertyType(blocks[0], false).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + (Object)((Object)PropertyType.getPropertyType(blocks[0], false));
            toReturn.setValueBlocks(blocks);
            if (!this.readDynamicRecords(toReturn, this.PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER)) {
                return null;
            }
            return toReturn;
        }

        private long[] readLongs(int count) {
            long[] result = new long[count];
            for (int i = 0; i < count; ++i) {
                result[i] = PhysicalLogNeoXaCommandReaderV0.this.scratch.getLong();
            }
            return result;
        }

        private SchemaRule readSchemaRule(Collection<DynamicRecord> recordsBefore) {
            SchemaRule rule;
            assert (IteratorUtil.first(recordsBefore).inUse()) : "Asked to deserialize schema records that were not in use.";
            ByteBuffer deserialized = AbstractDynamicStore.concatData(recordsBefore, new byte[100]);
            try {
                rule = SchemaRule.Kind.deserialize(IteratorUtil.first(recordsBefore).getId(), deserialized);
            }
            catch (MalformedSchemaRuleException e) {
                throw Exceptions.launderedException(e);
            }
            return rule;
        }
    }

    private static interface DynamicRecordAdder<T> {
        public void add(T var1, DynamicRecord var2);
    }
}

