/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.xa.TransactionWriter;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;

public class TransactionDataBuilder {
    private final TransactionWriter writer;

    public TransactionDataBuilder(TransactionWriter writer) {
        this.writer = writer;
    }

    public void createSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords) {
        try {
            this.writer.createSchema(beforeRecords, afterRecords);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void propertyKey(int id, String key) {
        try {
            this.writer.propertyKey(id, key, id);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void nodeLabel(int id, String name) {
        try {
            this.writer.label(id, name, id);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void relationshipType(int id, String relationshipType) {
        try {
            this.writer.relationshipType(id, relationshipType, id);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void create(NodeRecord node) {
        try {
            this.writer.create(node);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void create(LabelTokenRecord labelToken) {
        try {
            this.writer.create(labelToken);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void create(PropertyKeyTokenRecord token) {
        try {
            this.writer.create(token);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void create(RelationshipGroupRecord group) {
        try {
            this.writer.create(group);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void update(Command.SchemaRuleCommand command) {
        try {
            this.writer.updateSchema(command.getRecordsBefore(), command.getRecordsAfter());
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void create(Command.RelationshipTypeTokenCommand command) {
        try {
            this.writer.add(command.getRecord());
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void update(RelationshipGroupRecord group) {
        try {
            this.writer.update(group);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void delete(RelationshipGroupRecord group) {
        try {
            this.writer.delete(group);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void update(NeoStoreRecord record) {
        try {
            this.writer.update(record);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void update(NodeRecord before, NodeRecord after) {
        try {
            this.writer.update(before, after);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void delete(NodeRecord node) {
        try {
            this.writer.delete(node);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void create(RelationshipRecord relationship) {
        try {
            this.writer.create(relationship);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void update(RelationshipRecord relationship) {
        try {
            this.writer.update(relationship);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void delete(RelationshipRecord relationship) {
        try {
            this.writer.delete(relationship);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void create(PropertyRecord property) {
        try {
            this.writer.create(property);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void update(PropertyRecord before, PropertyRecord property) {
        try {
            this.writer.update(before, property);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    public void delete(PropertyRecord before, PropertyRecord property) {
        try {
            this.writer.delete(before, property);
        }
        catch (IOException e) {
            throw this.ioError(e);
        }
    }

    private Error ioError(IOException e) {
        return new ThisShouldNotHappenError("Mattias", "In-memory stuff should not throw IOException", e);
    }
}

