/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.statistics.SamplingStatisticsService;
import org.neo4j.kernel.impl.api.statistics.StaleStatisticsService;
import org.neo4j.kernel.impl.api.statistics.StatisticsService;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.JobScheduler;

public class StatisticsServiceRepository {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final StoreReadLayer store;
    private final JobScheduler scheduler;

    public StatisticsServiceRepository(FileSystemAbstraction fs, Config config, StoreReadLayer store, JobScheduler scheduler) {
        this.fs = fs;
        this.config = config;
        this.store = store;
        this.scheduler = scheduler;
    }

    public StatisticsService loadStatistics() {
        SamplingStatisticsService runtime = SamplingStatisticsService.load(this.fs, this.statisticsFile(), this.store, this.scheduler);
        if (this.config.get(InternalAbstractGraphDatabase.Configuration.statistics_enabled).booleanValue()) {
            return runtime;
        }
        return new StaleStatisticsService(runtime);
    }

    public void storeStatistics(StatisticsService statistics) throws IOException {
        if (statistics instanceof SamplingStatisticsService) {
            ((SamplingStatisticsService)statistics).save(this.fs, this.statisticsFile());
        }
    }

    private File statisticsFile() {
        return new File(this.config.get(GraphDatabaseSettings.store_dir), "neo4j.statistics");
    }
}

