/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;

public class StatementOperationParts {
    private final KeyReadOperations keyReadOperations;
    private final KeyWriteOperations keyWriteOperations;
    private final EntityReadOperations entityReadOperations;
    private final EntityWriteOperations entityWriteOperations;
    private final SchemaReadOperations schemaReadOperations;
    private final SchemaWriteOperations schemaWriteOperations;
    private final SchemaStateOperations schemaStateOperations;
    private final LockOperations lockingStatementOperations;

    public StatementOperationParts(KeyReadOperations keyReadOperations, KeyWriteOperations keyWriteOperations, EntityReadOperations entityReadOperations, EntityWriteOperations entityWriteOperations, SchemaReadOperations schemaReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaStateOperations schemaStateOperations, LockOperations lockingStatementOperations) {
        this.keyReadOperations = keyReadOperations;
        this.keyWriteOperations = keyWriteOperations;
        this.entityReadOperations = entityReadOperations;
        this.entityWriteOperations = entityWriteOperations;
        this.schemaReadOperations = schemaReadOperations;
        this.schemaWriteOperations = schemaWriteOperations;
        this.schemaStateOperations = schemaStateOperations;
        this.lockingStatementOperations = lockingStatementOperations;
    }

    public KeyReadOperations keyReadOperations() {
        return this.checkNotNull(this.keyReadOperations, KeyReadOperations.class);
    }

    public KeyWriteOperations keyWriteOperations() {
        return this.checkNotNull(this.keyWriteOperations, KeyWriteOperations.class);
    }

    public EntityReadOperations entityReadOperations() {
        return this.checkNotNull(this.entityReadOperations, EntityReadOperations.class);
    }

    public EntityWriteOperations entityWriteOperations() {
        return this.checkNotNull(this.entityWriteOperations, EntityWriteOperations.class);
    }

    public SchemaReadOperations schemaReadOperations() {
        return this.checkNotNull(this.schemaReadOperations, SchemaReadOperations.class);
    }

    public SchemaWriteOperations schemaWriteOperations() {
        return this.checkNotNull(this.schemaWriteOperations, SchemaWriteOperations.class);
    }

    public SchemaStateOperations schemaStateOperations() {
        return this.checkNotNull(this.schemaStateOperations, SchemaStateOperations.class);
    }

    public LockOperations locking() {
        return this.checkNotNull(this.lockingStatementOperations, LockOperations.class);
    }

    public StatementOperationParts override(KeyReadOperations keyReadOperations, KeyWriteOperations keyWriteOperations, EntityReadOperations entityReadOperations, EntityWriteOperations entityWriteOperations, SchemaReadOperations schemaReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaStateOperations schemaStateOperations, LockOperations lockingStatementOperations) {
        return new StatementOperationParts(this.eitherOr(keyReadOperations, this.keyReadOperations, KeyReadOperations.class), this.eitherOr(keyWriteOperations, this.keyWriteOperations, KeyWriteOperations.class), this.eitherOr(entityReadOperations, this.entityReadOperations, EntityReadOperations.class), this.eitherOr(entityWriteOperations, this.entityWriteOperations, EntityWriteOperations.class), this.eitherOr(schemaReadOperations, this.schemaReadOperations, SchemaReadOperations.class), this.eitherOr(schemaWriteOperations, this.schemaWriteOperations, SchemaWriteOperations.class), this.eitherOr(schemaStateOperations, this.schemaStateOperations, SchemaStateOperations.class), this.eitherOr(lockingStatementOperations, this.lockingStatementOperations, LockOperations.class));
    }

    private <T> T checkNotNull(T object, Class<T> cls) {
        if (object == null) {
            throw new IllegalStateException("No part of type " + cls.getSimpleName() + " assigned");
        }
        return object;
    }

    private <T> T eitherOr(T first, T other, Class<T> cls) {
        return first != null ? first : other;
    }
}

