/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.xa.PropertyCreator;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class Utils {
    public static long[] labelNamesToIds(BatchingTokenRepository<?> labelHolder, String[] labels) {
        long[] result = new long[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            result[i] = labelHolder.getOrCreateId(labels[i]);
        }
        return result;
    }

    public static Iterator<PropertyBlock> propertyKeysAndValues(final Object[] properties, final BatchingTokenRepository<?> propetyKeyHolder, final PropertyCreator creator) {
        return new PrefetchingIterator<PropertyBlock>(){
            private int cursor;

            @Override
            protected PropertyBlock fetchNextOrNull() {
                if (this.cursor >= properties.length) {
                    return null;
                }
                int key = propetyKeyHolder.getOrCreateId((String)properties[this.cursor++]);
                Object value = properties[this.cursor++];
                return creator.encodeValue(new PropertyBlock(), key, value);
            }
        };
    }

    public static int safeCastLongToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (int)value;
    }

    private Utils() {
    }
}

