/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.labels.InlineNodeLabels;
import org.neo4j.kernel.impl.nioneo.xa.PropertyCreator;
import org.neo4j.unsafe.impl.batchimport.RecordBatch;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPropertyRecordAccess;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public final class NodeEncoderStep
extends ExecutorServiceStep<List<InputNode>> {
    private final NodeStore nodeStore;
    private final BatchingTokenRepository<?> propertyKeyHolder;
    private final BatchingTokenRepository<?> labelHolder;
    private final PropertyCreator propertyCreator;

    public NodeEncoderStep(StageControl control, String name, int workAheadSize, int numberOfExecutors, BatchingTokenRepository<?> propertyKeyHolder, BatchingTokenRepository<?> labelHolder, NodeStore nodeStore, PropertyStore propertyStore) {
        super(control, name, workAheadSize, numberOfExecutors);
        this.nodeStore = nodeStore;
        this.propertyKeyHolder = propertyKeyHolder;
        this.labelHolder = labelHolder;
        this.propertyCreator = new PropertyCreator(propertyStore, null);
    }

    @Override
    protected Object process(long ticket, List<InputNode> batch) {
        BatchingPropertyRecordAccess propertyRecords = new BatchingPropertyRecordAccess();
        ArrayList<NodeRecord> nodeRecords = new ArrayList<NodeRecord>(batch.size());
        for (InputNode batchNode : batch) {
            long nodeId = batchNode.id();
            NodeRecord nodeRecord = new NodeRecord(nodeId, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
            nodeRecord.setInUse(true);
            nodeRecords.add(nodeRecord);
            long nextProp = batchNode.hasFirstPropertyId() ? batchNode.firstPropertyId() : this.propertyCreator.createPropertyChain(nodeRecord, Utils.propertyKeysAndValues(batchNode.properties(), this.propertyKeyHolder, this.propertyCreator), propertyRecords);
            nodeRecord.setNextProp(nextProp);
            if (batchNode.hasLabelField()) {
                nodeRecord.setLabelField(batchNode.labelField(), Collections.emptyList());
                continue;
            }
            long[] labels = Utils.labelNamesToIds(this.labelHolder, batchNode.labels());
            new InlineNodeLabels(nodeRecord.getLabelField(), nodeRecord).put(labels, null, this.nodeStore.getDynamicLabelStore());
        }
        return new RecordBatch(nodeRecords, propertyRecords.records());
    }
}

