/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.Collection;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.Loaders;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccess;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccessSet;
import org.neo4j.unsafe.batchinsert.DirectRecordAccess;

public class DirectRecordAccessSet
implements RecordAccessSet {
    private final DirectRecordAccess<Long, NodeRecord, Void> nodeRecords;
    private final DirectRecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords;
    private final DirectRecordAccess<Long, RelationshipRecord, Void> relationshipRecords;
    private final DirectRecordAccess<Long, RelationshipGroupRecord, Integer> relationshipGroupRecords;

    public DirectRecordAccessSet(NeoStore neoStore) {
        this.nodeRecords = new DirectRecordAccess<Long, NodeRecord, Void>(neoStore.getNodeStore(), Loaders.nodeLoader(neoStore.getNodeStore()));
        this.propertyRecords = new DirectRecordAccess<Long, PropertyRecord, PrimitiveRecord>(neoStore.getPropertyStore(), Loaders.propertyLoader(neoStore.getPropertyStore()));
        this.relationshipRecords = new DirectRecordAccess<Long, RelationshipRecord, Void>(neoStore.getRelationshipStore(), Loaders.relationshipLoader(neoStore.getRelationshipStore()));
        this.relationshipGroupRecords = new DirectRecordAccess<Long, RelationshipGroupRecord, Integer>(neoStore.getRelationshipGroupStore(), Loaders.relationshipGroupLoader(neoStore.getRelationshipGroupStore()));
    }

    @Override
    public RecordAccess<Long, NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<Long, RelationshipRecord, Void> getRelRecords() {
        return this.relationshipRecords;
    }

    @Override
    public RecordAccess<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relationshipGroupRecords;
    }

    @Override
    public RecordAccess<Long, Collection<DynamicRecord>, SchemaRule> getSchemaRuleChanges() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.commit();
        this.nodeRecords.close();
        this.propertyRecords.close();
        this.relationshipRecords.close();
        this.relationshipGroupRecords.close();
    }

    public void commit() {
        this.nodeRecords.commit();
        this.propertyRecords.commit();
        this.relationshipGroupRecords.commit();
        this.relationshipRecords.commit();
    }
}

