/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ModuleMapper {
    Map<String, String> modules;

    public ModuleMapper() throws IOException {
        Properties props = new Properties();
        this.modules = new HashMap<String, String>();
        Enumeration<URL> moduleDefinitions = this.getClass().getClassLoader().getResources("META-INF/modules.properties");
        while (moduleDefinitions.hasMoreElements()) {
            URL url = moduleDefinitions.nextElement();
            props.load(new InputStreamReader(url.openStream()));
            for (Map.Entry<Object, Object> propEntry : props.entrySet()) {
                String packages = this.modules.get(propEntry.getKey());
                packages = packages == null ? propEntry.getValue().toString() : packages + "," + propEntry.getValue().toString();
                this.modules.put(propEntry.getKey().toString(), packages);
            }
            props.clear();
        }
    }

    public String map(String logger) {
        for (Map.Entry<String, String> moduleEntry : this.modules.entrySet()) {
            String[] packages;
            for (String aPackage : packages = moduleEntry.getValue().split(",")) {
                if (!logger.startsWith(aPackage)) continue;
                return moduleEntry.getKey();
            }
        }
        return logger;
    }
}

