/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.LogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;
import org.neo4j.kernel.impl.util.StringLogger;

class PartialTransactionCopier {
    private final ByteBuffer sharedBuffer;
    private final LogEntryWriterv1 logEntryWriter;
    private final XaCommandReaderFactory commandReaderFactory;
    private final XaCommandWriterFactory commandWriterFactory;
    private final StringLogger log;
    private final LogExtractor.LogPositionCache positionCache;
    private final LogExtractor.LogLoader logLoader;
    private final ArrayMap<Integer, LogEntry.Start> xidIdentMap;
    private final DoesSomethingConsumer consumer;

    PartialTransactionCopier(ByteBuffer sharedBuffer, XaCommandReaderFactory commandReaderFactory, XaCommandWriterFactory commandWriterFactory, StringLogger log, LogExtractor.LogPositionCache positionCache, LogExtractor.LogLoader logLoader, LogEntryWriterv1 logEntryWriter, ArrayMap<Integer, LogEntry.Start> xidIdentMap) {
        this.sharedBuffer = sharedBuffer;
        this.logEntryWriter = logEntryWriter;
        this.commandReaderFactory = commandReaderFactory;
        this.commandWriterFactory = commandWriterFactory;
        this.log = log;
        this.positionCache = positionCache;
        this.logLoader = logLoader;
        this.xidIdentMap = xidIdentMap;
        this.consumer = new DoesSomethingConsumer();
    }

    public void copy(StoreChannel sourceLog, LogBuffer targetLog, long targetLogVersion) throws IOException {
        LogDeserializer deserializer = new LogDeserializer(this.sharedBuffer, this.commandReaderFactory);
        this.consumer.init(targetLog, targetLogVersion);
        Cursor<LogEntry, IOException> cursor = deserializer.cursor(sourceLog);
        while (cursor.next(this.consumer)) {
        }
    }

    private class DoesSomethingConsumer
    implements Consumer<LogEntry, IOException> {
        private final Map<Integer, LogEntry.Start> startEntriesEncountered = new HashMap<Integer, LogEntry.Start>();
        private final IAmNotReallySureWhatThisDoes consumer = new IAmNotReallySureWhatThisDoes();
        private boolean foundFirstActiveTx;
        private LogBuffer targetLog;
        private long targetLogVersion;

        private DoesSomethingConsumer() {
        }

        public void init(LogBuffer targetLog, long targetLogVersion) {
            this.targetLog = targetLog;
            this.targetLogVersion = targetLogVersion;
            this.foundFirstActiveTx = false;
            this.startEntriesEncountered.clear();
        }

        @Override
        public boolean accept(LogEntry logEntry) throws IOException {
            boolean isActive;
            Integer identifier = logEntry.getIdentifier();
            boolean bl = isActive = PartialTransactionCopier.this.xidIdentMap.get(identifier) != null;
            if (!this.foundFirstActiveTx && isActive) {
                this.foundFirstActiveTx = true;
            }
            if (this.foundFirstActiveTx) {
                if (logEntry instanceof LogEntry.Start) {
                    LogEntry.Start startEntry = (LogEntry.Start)logEntry;
                    this.startEntriesEncountered.put(identifier, startEntry);
                    startEntry.setStartPosition(this.targetLog.getFileChannelPosition());
                    if (isActive) {
                        PartialTransactionCopier.this.xidIdentMap.put(identifier, startEntry);
                    }
                } else if (logEntry instanceof LogEntry.Commit) {
                    LogEntry.Commit commitEntry = (LogEntry.Commit)logEntry;
                    LogEntry.Start startEntry = this.startEntriesEncountered.get(identifier);
                    if (startEntry == null) {
                        startEntry = this.fetchTransactionBulkFromLogExtractor(commitEntry.getTxId());
                        this.startEntriesEncountered.put(identifier, startEntry);
                    } else {
                        LogExtractor.TxPosition oldPos = PartialTransactionCopier.this.positionCache.getStartPosition(commitEntry.getTxId());
                        LogExtractor.TxPosition newPos = PartialTransactionCopier.this.positionCache.cacheStartPosition(commitEntry.getTxId(), startEntry, this.targetLogVersion);
                        PartialTransactionCopier.this.log.logMessage("Updated tx " + ((LogEntry.Commit)logEntry).getTxId() + " from " + oldPos + " to " + newPos);
                    }
                }
                if (this.startEntriesEncountered.containsKey(identifier)) {
                    PartialTransactionCopier.this.logEntryWriter.writeLogEntry(logEntry, this.targetLog);
                }
            }
            return true;
        }

        private LogEntry.Start fetchTransactionBulkFromLogExtractor(long txId) throws IOException {
            LogExtractor extractor = new LogExtractor(PartialTransactionCopier.this.positionCache, PartialTransactionCopier.this.logLoader, PartialTransactionCopier.this.commandReaderFactory, PartialTransactionCopier.this.commandWriterFactory, PartialTransactionCopier.this.logEntryWriter, txId, txId);
            try (Cursor<LogEntry, IOException> cursor = extractor.cursor(new InMemoryLogBuffer());){
                while (cursor.next(this.consumer)) {
                }
            }
            return extractor.getLastStartEntry();
        }

        private class IAmNotReallySureWhatThisDoes
        implements Consumer<LogEntry, IOException> {
            private IAmNotReallySureWhatThisDoes() {
            }

            @Override
            public boolean accept(LogEntry entry) throws IOException {
                if (entry instanceof LogEntry.Commit) {
                    return false;
                }
                PartialTransactionCopier.this.logEntryWriter.writeLogEntry(entry, DoesSomethingConsumer.this.targetLog);
                return true;
            }
        }
    }
}

