/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.DelegatingRecordStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaStore;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreAccess {
    private final RecordStore<DynamicRecord> schemaStore;
    private final RecordStore<NodeRecord> nodeStore;
    private final RecordStore<RelationshipRecord> relStore;
    private final RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore;
    private final RecordStore<LabelTokenRecord> labelTokenStore;
    private final RecordStore<DynamicRecord> nodeDynamicLabelStore;
    private final RecordStore<PropertyRecord> propStore;
    private final RecordStore<DynamicRecord> stringStore;
    private final RecordStore<DynamicRecord> arrayStore;
    private final RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore;
    private final RecordStore<DynamicRecord> relationshipTypeNameStore;
    private final RecordStore<DynamicRecord> labelNameStore;
    private final RecordStore<DynamicRecord> propertyKeyNameStore;
    private final RecordStore<RelationshipGroupRecord> relGroupStore;
    private boolean closeable;
    private NeoStore neoStore;

    public StoreAccess(GraphDatabaseAPI graphdb) {
        this(StoreAccess.getNeoStoreFrom(graphdb));
    }

    private static NeoStore getNeoStoreFrom(GraphDatabaseAPI graphdb) {
        return graphdb.getDependencyResolver().resolveDependency(XaDataSourceManager.class).getNeoStoreDataSource().getNeoStore();
    }

    public StoreAccess(NeoStore store) {
        this(store.getSchemaStore(), store.getNodeStore(), store.getRelationshipStore(), store.getPropertyStore(), store.getRelationshipTypeStore(), store.getLabelTokenStore(), store.getRelationshipGroupStore());
        this.neoStore = store;
    }

    public StoreAccess(SchemaStore schemaStore, NodeStore nodeStore, RelationshipStore relStore, PropertyStore propStore, RelationshipTypeTokenStore typeStore, LabelTokenStore labelTokenStore, RelationshipGroupStore relGroupStore) {
        this.schemaStore = this.wrapStore(schemaStore);
        this.nodeStore = this.wrapStore(nodeStore);
        this.relStore = this.wrapStore(relStore);
        this.propStore = this.wrapStore(propStore);
        this.stringStore = this.wrapStore(propStore.getStringStore());
        this.arrayStore = this.wrapStore(propStore.getArrayStore());
        this.relationshipTypeTokenStore = this.wrapStore(typeStore);
        this.labelTokenStore = this.wrapStore(labelTokenStore);
        this.nodeDynamicLabelStore = this.wrapStore(StoreAccess.wrapNodeDynamicLabelStore(nodeStore.getDynamicLabelStore()));
        this.propertyKeyTokenStore = this.wrapStore(propStore.getPropertyKeyTokenStore());
        this.relationshipTypeNameStore = this.wrapStore(typeStore.getNameStore());
        this.labelNameStore = this.wrapStore(labelTokenStore.getNameStore());
        this.propertyKeyNameStore = this.wrapStore(propStore.getPropertyKeyTokenStore().getNameStore());
        this.relGroupStore = this.wrapStore(relGroupStore);
    }

    public StoreAccess(String path) {
        this(path, StoreAccess.defaultParams());
    }

    public StoreAccess(FileSystemAbstraction fileSystem, String path) {
        this(fileSystem, path, StoreAccess.defaultParams());
    }

    public StoreAccess(String path, Map<String, String> params) {
        this(new DefaultFileSystemAbstraction(), path, params);
    }

    public StoreAccess(FileSystemAbstraction fileSystem, String path, Map<String, String> params) {
        this(new StoreFactory(new Config(StoreAccess.requiredParams(params, path)), new DefaultIdGeneratorFactory(), new DefaultWindowPoolFactory(), fileSystem, StringLogger.DEV_NULL, new DefaultTxHook()).newNeoStore(new File(path, "neostore")));
        this.closeable = true;
    }

    private static Map<String, String> requiredParams(Map<String, String> params, String path) {
        params = new HashMap<String, String>(params);
        params.put("neo_store", new File(path, "neostore").getPath());
        return params;
    }

    public NeoStore getRawNeoStore() {
        return this.neoStore;
    }

    public RecordStore<DynamicRecord> getSchemaStore() {
        return this.schemaStore;
    }

    public RecordStore<NodeRecord> getNodeStore() {
        return this.nodeStore;
    }

    public RecordStore<RelationshipRecord> getRelationshipStore() {
        return this.relStore;
    }

    public RecordStore<RelationshipGroupRecord> getRelationshipGroupStore() {
        return this.relGroupStore;
    }

    public RecordStore<PropertyRecord> getPropertyStore() {
        return this.propStore;
    }

    public RecordStore<DynamicRecord> getStringStore() {
        return this.stringStore;
    }

    public RecordStore<DynamicRecord> getArrayStore() {
        return this.arrayStore;
    }

    public RecordStore<RelationshipTypeTokenRecord> getRelationshipTypeTokenStore() {
        return this.relationshipTypeTokenStore;
    }

    public RecordStore<LabelTokenRecord> getLabelTokenStore() {
        return this.labelTokenStore;
    }

    public RecordStore<DynamicRecord> getNodeDynamicLabelStore() {
        return this.nodeDynamicLabelStore;
    }

    public RecordStore<PropertyKeyTokenRecord> getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    public RecordStore<DynamicRecord> getRelationshipTypeNameStore() {
        return this.relationshipTypeNameStore;
    }

    public RecordStore<DynamicRecord> getLabelNameStore() {
        return this.labelNameStore;
    }

    public RecordStore<DynamicRecord> getPropertyKeyNameStore() {
        return this.propertyKeyNameStore;
    }

    public final <F extends Exception, P extends RecordStore.Processor<F>> P applyToAll(P processor) throws F {
        for (RecordStore<?> store : this.allStores()) {
            this.apply(processor, store);
        }
        return processor;
    }

    protected RecordStore<?>[] allStores() {
        if (this.propStore == null) {
            return new RecordStore[]{this.nodeStore, this.relStore, this.relationshipTypeTokenStore, this.relationshipTypeNameStore, this.labelTokenStore, this.labelNameStore, this.nodeDynamicLabelStore};
        }
        return new RecordStore[]{this.schemaStore, this.nodeStore, this.relStore, this.propStore, this.stringStore, this.arrayStore, this.relationshipTypeTokenStore, this.propertyKeyTokenStore, this.labelTokenStore, this.relationshipTypeNameStore, this.propertyKeyNameStore, this.labelNameStore, this.nodeDynamicLabelStore};
    }

    private static RecordStore<DynamicRecord> wrapNodeDynamicLabelStore(RecordStore<DynamicRecord> store) {
        return new DelegatingRecordStore<DynamicRecord>(store){

            @Override
            public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
                processor.processLabelArrayWithOwner(this, record);
            }
        };
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        return store;
    }

    protected <FAILURE extends Exception> void apply(RecordStore.Processor<FAILURE> processor, RecordStore<?> store) throws FAILURE {
        processor.applyFiltered(store, RecordStore.IN_USE);
    }

    private static Map<String, String> defaultParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GraphDatabaseSettings.nodestore_mapped_memory_size.name(), "20M");
        params.put(GraphDatabaseSettings.nodestore_propertystore_mapped_memory_size.name(), "90M");
        params.put(GraphDatabaseSettings.nodestore_propertystore_index_mapped_memory_size.name(), "1M");
        params.put(GraphDatabaseSettings.nodestore_propertystore_index_keys_mapped_memory_size.name(), "1M");
        params.put(GraphDatabaseSettings.strings_mapped_memory_size.name(), "130M");
        params.put(GraphDatabaseSettings.arrays_mapped_memory_size.name(), "130M");
        params.put(GraphDatabaseSettings.relationshipstore_mapped_memory_size.name(), "100M");
        if (Settings.osIsWindows()) {
            params.put(GraphDatabaseSettings.use_memory_mapped_buffers.name(), "false");
        }
        params.put(GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "true");
        return params;
    }

    public synchronized void close() {
        if (this.closeable) {
            this.closeable = false;
            this.neoStore.close();
        }
    }
}

