/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;

@Deprecated
public class TopLevelTransaction
implements org.neo4j.graphdb.Transaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final AbstractTransactionManager transactionManager;
    private final ThreadToStatementContextBridge stmtProvider;
    protected final TransactionOutcome transactionOutcome = new TransactionOutcome();

    public TopLevelTransaction(AbstractTransactionManager transactionManager, ThreadToStatementContextBridge stmtProvider) {
        this.transactionManager = transactionManager;
        this.stmtProvider = stmtProvider;
    }

    @Override
    public void failure() {
        this.transactionOutcome.failed();
        this.markAsRollbackOnly();
    }

    protected void markAsRollbackOnly() {
        try {
            this.transactionManager.getTransaction().setRollbackOnly();
        }
        catch (Exception e) {
            throw new TransactionFailureException("Failed to mark transaction as rollback only.", e);
        }
    }

    @Override
    public void success() {
        this.transactionOutcome.success();
    }

    @Override
    public final void finish() {
        this.close();
    }

    @Override
    public void close() {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction != null) {
                if (this.transactionOutcome.canCommit()) {
                    transaction.commit();
                } else {
                    transaction.rollback();
                }
            }
        }
        catch (RollbackException e) {
            throw new TransactionFailureException("Unable to commit transaction", e);
        }
        catch (Exception e) {
            if (this.transactionOutcome.successCalled()) {
                throw new TransactionFailureException("Unable to commit transaction", e);
            }
            throw new TransactionFailureException("Unable to rollback transaction", e);
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.stmtProvider, entity);
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.stmtProvider, entity);
    }

    static class TransactionOutcome {
        private boolean success = false;
        private boolean failure = false;

        TransactionOutcome() {
        }

        public void failed() {
            this.failure = true;
        }

        public void success() {
            this.success = true;
        }

        public boolean canCommit() {
            return this.success && !this.failure;
        }

        public boolean successCalled() {
            return this.success;
        }

        public boolean failureCalled() {
            return this.failure;
        }
    }
}

