/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class InterceptingXaLogicalLog
extends XaLogicalLog {
    private final XaDataSource ds;
    private final TransactionInterceptorProviders providers;

    public InterceptingXaLogicalLog(File fileName, XaResourceManager xaRm, XaCommandFactory cf, XaTransactionFactory xaTf, TransactionInterceptorProviders providers, Monitors monitors, FileSystemAbstraction fileSystem, Logging logging, LogPruneStrategy pruneStrategy, TransactionStateFactory stateFactory, KernelHealth kernelHealth, long rotateAtSize, InjectedTransactionValidator injectedTxValidator) {
        super(fileName, xaRm, cf, xaTf, fileSystem, monitors, logging, pruneStrategy, stateFactory, kernelHealth, rotateAtSize, injectedTxValidator);
        this.providers = providers;
        this.ds = xaRm.getDataSource();
    }

    @Override
    protected XaLogicalLog.LogDeserializer getLogDeserializer(ReadableByteChannel byteChannel) {
        final TransactionInterceptor interceptor = this.providers.resolveChain(this.ds);
        XaLogicalLog.LogDeserializer toReturn = new XaLogicalLog.LogDeserializer(byteChannel, this.bufferMonitor){

            @Override
            protected void intercept(List<LogEntry> entries) {
                for (LogEntry entry : entries) {
                    if (entry instanceof LogEntry.Command) {
                        LogEntry.Command commandEntry = (LogEntry.Command)entry;
                        if (!(commandEntry.getXaCommand() instanceof Command)) continue;
                        ((Command)commandEntry.getXaCommand()).accept(interceptor);
                        continue;
                    }
                    if (entry instanceof LogEntry.Start) {
                        interceptor.setStartEntry((LogEntry.Start)entry);
                        continue;
                    }
                    if (!(entry instanceof LogEntry.Commit)) continue;
                    interceptor.setCommitEntry((LogEntry.Commit)entry);
                }
                interceptor.complete();
            }
        };
        return toReturn;
    }
}

