/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class ByteArrayProperty
extends DefinedProperty {
    private final byte[] value;

    ByteArrayProperty(int propertyKeyId, byte[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public byte[] value() {
        return (byte[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof byte[]) {
            return Arrays.equals(this.value, (byte[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return Arrays.equals(this.value, ((ByteArrayProperty)that).value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

