/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class BooleanArrayProperty
extends DefinedProperty {
    private final boolean[] value;

    BooleanArrayProperty(int propertyKeyId, boolean[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public boolean[] value() {
        return (boolean[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof boolean[]) {
            return Arrays.equals(this.value, (boolean[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return Arrays.equals(this.value, ((BooleanArrayProperty)that).value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

