/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.kernel.api.TokenNameLookup;

public class UniquenessConstraint {
    private final int labelId;
    private final int propertyKeyId;

    public UniquenessConstraint(int labelId, int propertyKeyId) {
        this.labelId = labelId;
        this.propertyKeyId = propertyKeyId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            UniquenessConstraint that = (UniquenessConstraint)obj;
            return this.equals(that.labelId, that.propertyKeyId);
        }
        return false;
    }

    public int hashCode() {
        int result = this.labelId;
        result = 31 * result + this.propertyKeyId;
        return result;
    }

    public int label() {
        return this.labelId;
    }

    public int propertyKeyId() {
        return this.propertyKeyId;
    }

    public boolean equals(int labelId, int propertyKeyId) {
        return this.labelId == labelId && this.propertyKeyId == propertyKeyId;
    }

    public String toString() {
        return String.format("CONSTRAINT ON ( n:label[%s] ) ASSERT n.property[%s] IS UNIQUE", this.labelId, this.propertyKeyId);
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        String labelName = tokenNameLookup.labelGetName(this.labelId);
        String boundIdentifier = labelName.toLowerCase();
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s.%s IS UNIQUE", boundIdentifier, labelName, boundIdentifier, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }
}

