/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;

public class RecordChanges<KEY, RECORD, ADDITIONAL> {
    private final Map<KEY, RecordChange<KEY, RECORD, ADDITIONAL>> recordChanges = new HashMap<KEY, RecordChange<KEY, RECORD, ADDITIONAL>>();
    private final Loader<KEY, RECORD, ADDITIONAL> loader;
    private final boolean manageBeforeState;

    public RecordChanges(Loader<KEY, RECORD, ADDITIONAL> loader, boolean manageBeforeState) {
        this.loader = loader;
        this.manageBeforeState = manageBeforeState;
    }

    public RecordChange<KEY, RECORD, ADDITIONAL> getIfLoaded(KEY key) {
        return this.recordChanges.get(key);
    }

    public RecordChange<KEY, RECORD, ADDITIONAL> getOrLoad(KEY key, ADDITIONAL additionalData) {
        RecordChange<KEY, RECORD, ADDITIONAL> result = this.recordChanges.get(key);
        if (result == null) {
            result = new RecordChange<KEY, RECORD, ADDITIONAL>(this.recordChanges, key, this.loader.load(key, additionalData), this.loader, this.manageBeforeState, false, additionalData);
        }
        return result;
    }

    public int changeSize() {
        return IteratorUtil.count(this.changes());
    }

    public void clear() {
        this.recordChanges.clear();
    }

    public RecordChange<KEY, RECORD, ADDITIONAL> create(KEY key, ADDITIONAL additionalData) {
        if (this.recordChanges.containsKey(key)) {
            throw new IllegalStateException(key + " already exists");
        }
        RECORD record = this.loader.newUnused(key, additionalData);
        RecordChange<KEY, RECORD, ADDITIONAL> change = new RecordChange<KEY, RECORD, ADDITIONAL>(this.recordChanges, key, record, this.loader, this.manageBeforeState, true, additionalData);
        this.recordChanges.put(key, change);
        return change;
    }

    public Iterable<RecordChange<KEY, RECORD, ADDITIONAL>> changes() {
        return Iterables.filter(new Predicate<RecordChange<KEY, RECORD, ADDITIONAL>>(){

            @Override
            public boolean accept(RecordChange<KEY, RECORD, ADDITIONAL> item) {
                return item.isChanged();
            }
        }, this.recordChanges.values());
    }

    public static interface Loader<KEY, RECORD, ADDITIONAL> {
        public RECORD newUnused(KEY var1, ADDITIONAL var2);

        public RECORD load(KEY var1, ADDITIONAL var2);

        public void ensureHeavy(RECORD var1);

        public RECORD clone(RECORD var1);
    }

    public static class RecordChange<KEY, RECORD, ADDITIONAL> {
        private final Map<KEY, RecordChange<KEY, RECORD, ADDITIONAL>> allChanges;
        private final ADDITIONAL additionalData;
        private RECORD before;
        private final RECORD record;
        private final Loader<KEY, RECORD, ADDITIONAL> loader;
        private boolean changed;
        private final boolean created;
        private final KEY key;
        private final boolean manageBeforeState;

        public RecordChange(Map<KEY, RecordChange<KEY, RECORD, ADDITIONAL>> allChanges, KEY key, RECORD record, Loader<KEY, RECORD, ADDITIONAL> loader, boolean manageBeforeState, boolean created, ADDITIONAL additionalData) {
            this.allChanges = allChanges;
            this.key = key;
            this.record = record;
            this.loader = loader;
            this.manageBeforeState = manageBeforeState;
            this.created = created;
            this.additionalData = additionalData;
        }

        KEY getKey() {
            return this.key;
        }

        RECORD forChangingLinkage() {
            return this.prepareForChange();
        }

        RECORD forChangingData() {
            this.ensureHeavy();
            return this.prepareForChange();
        }

        private RECORD prepareForChange() {
            this.ensureHasBeforeRecordImage();
            if (!this.changed) {
                this.allChanges.put(this.key, this);
                this.changed = true;
            }
            return this.record;
        }

        private void ensureHeavy() {
            if (!this.created) {
                this.loader.ensureHeavy(this.record);
                if (this.before != null) {
                    this.loader.ensureHeavy(this.before);
                }
            }
        }

        RECORD forReadingLinkage() {
            return this.record;
        }

        RECORD forReadingData() {
            this.ensureHeavy();
            return this.record;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public RECORD getBefore() {
            this.ensureHasBeforeRecordImage();
            if (!this.manageBeforeState) {
                throw new UnsupportedOperationException("This RecordChanges instance doesn't manage before-state");
            }
            return this.before;
        }

        private void ensureHasBeforeRecordImage() {
            if (this.manageBeforeState && this.before == null) {
                this.before = this.loader.clone(this.record);
            }
        }

        public boolean isCreated() {
            return this.created;
        }

        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }
    }
}

