/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractRecordStore;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.labels.LabelIdArray;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.StringLogger;

public class NodeStore
extends AbstractRecordStore<NodeRecord>
implements Store {
    public static final String TYPE_DESCRIPTOR = "NodeStore";
    public static final int RECORD_SIZE = 14;
    private DynamicArrayStore dynamicLabelStore;

    public static Long readOwnerFromDynamicLabelsRecord(DynamicRecord record) {
        byte[] data = record.getData();
        byte[] header = PropertyType.ARRAY.readDynamicRecordHeader(data);
        byte[] array = Arrays.copyOfRange(data, header.length, data.length);
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return null;
        }
        Bits bits = Bits.bitsFromBytes(array);
        return bits.getLong(requiredBits);
    }

    public NodeStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicArrayStore dynamicLabelStore) {
        super(fileName, config, IdType.NODE, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
        this.dynamicLabelStore = dynamicLabelStore;
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, NodeRecord record) throws FAILURE {
        processor.processNode(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 14;
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    public void ensureHeavy(NodeRecord node) {
        NodeLabelsField.parseLabelsField(node).ensureHeavy(this);
    }

    public void ensureHeavy(NodeRecord node, long firstDynamicLabelRecord) {
        if (!node.isLight()) {
            return;
        }
        node.setLabelField(node.getLabelField(), this.dynamicLabelStore.getRecords(firstDynamicLabelRecord));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRecord getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            NodeRecord nodeRecord = this.getRecord(id, window, RecordLoad.NORMAL);
            return nodeRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRecord forceGetRecord(long id) {
        PersistenceWindow window;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return new NodeRecord(id, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        try {
            NodeRecord nodeRecord = this.getRecord(id, window, RecordLoad.FORCE);
            return nodeRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public NodeRecord forceGetRaw(NodeRecord record) {
        return record;
    }

    @Override
    public NodeRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateRecord(NodeRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window, true);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(NodeRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window, false);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRecord loadLightNode(long id) {
        PersistenceWindow window;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return null;
        }
        try {
            NodeRecord nodeRecord = this.getRecord(id, window, RecordLoad.CHECK);
            return nodeRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private NodeRecord getRecord(long id, PersistenceWindow window, RecordLoad load) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (!inUse) {
            switch (load) {
                case NORMAL: {
                    throw new InvalidRecordException("NodeRecord[" + id + "] not in use");
                }
                case CHECK: {
                    return null;
                }
            }
        }
        long nextRel = buffer.getUnsignedInt();
        long nextProp = buffer.getUnsignedInt();
        long relModifier = (inUseByte & 0xEL) << 31;
        long propModifier = (inUseByte & 0xF0L) << 28;
        long lsbLabels = buffer.getUnsignedInt();
        long hsbLabels = buffer.get() & 0xFF;
        long labels = lsbLabels | hsbLabels << 32;
        NodeRecord nodeRecord = new NodeRecord(id, this.longFromIntAndMod(nextRel, relModifier), this.longFromIntAndMod(nextProp, propModifier));
        nodeRecord.setInUse(inUse);
        nodeRecord.setLabelField(labels, Collections.emptyList());
        return nodeRecord;
    }

    private void updateRecord(NodeRecord record, PersistenceWindow window, boolean force) {
        long id = record.getId();
        this.registerIdFromUpdateRecord(id);
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse() || force) {
            long nextRel = record.getNextRel();
            long nextProp = record.getNextProp();
            short relModifier = nextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((nextRel & 0x700000000L) >> 31);
            int propModifier = (short)(nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0 : (short)((nextProp & 0xF00000000L) >> 28));
            short inUseUnsignedByte = (record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue();
            inUseUnsignedByte = (short)(inUseUnsignedByte | relModifier | propModifier);
            buffer.put((byte)inUseUnsignedByte).putInt((int)nextRel).putInt((int)nextProp);
            long labelField = record.getLabelField();
            buffer.putInt((int)labelField);
            buffer.put((byte)((labelField & 0xFF00000000L) >> 32));
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.getWindowPoolStats());
        return list;
    }

    public DynamicArrayStore getDynamicLabelStore() {
        return this.dynamicLabelStore;
    }

    @Override
    protected void closeStorage() {
        if (this.dynamicLabelStore != null) {
            this.dynamicLabelStore.close();
            this.dynamicLabelStore = null;
        }
    }

    public Collection<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, long[] labels) {
        return this.allocateRecordsForDynamicLabels(nodeId, labels, Collections.emptyList().iterator());
    }

    public Collection<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, long[] labels, Iterator<DynamicRecord> useFirst) {
        long[] storedLongs = LabelIdArray.prependNodeId(nodeId, labels);
        return this.dynamicLabelStore.allocateRecords(storedLongs, useFirst);
    }

    public long[] getDynamicLabelsArray(Iterable<DynamicRecord> records) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(this.dynamicLabelStore.readFullByteArray(records, PropertyType.ARRAY));
        return LabelIdArray.stripNodeId(storedLongs);
    }

    public Pair<Long, long[]> getDynamicLabelsArrayAndOwner(Iterable<DynamicRecord> records) {
        long[] storedLongs = (long[])DynamicArrayStore.getRightArray(this.dynamicLabelStore.readFullByteArray(records, PropertyType.ARRAY));
        return Pair.of(storedLongs[0], LabelIdArray.stripNodeId(storedLongs));
    }

    public void updateDynamicLabelRecords(Iterable<DynamicRecord> dynamicLabelRecords) {
        for (DynamicRecord record : dynamicLabelRecords) {
            this.dynamicLabelStore.updateRecord(record);
        }
    }

    @Override
    protected void setRecovered() {
        this.dynamicLabelStore.setRecovered();
        super.setRecovered();
    }

    @Override
    protected void unsetRecovered() {
        this.dynamicLabelStore.unsetRecovered();
        super.unsetRecovered();
    }

    @Override
    public void makeStoreOk() {
        this.dynamicLabelStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.dynamicLabelStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    protected void updateIdGenerators() {
        this.dynamicLabelStore.updateHighId();
        super.updateHighId();
    }

    @Override
    public void flushAll() {
        this.dynamicLabelStore.flushAll();
        super.flushAll();
    }

    public static abstract class Configuration
    extends AbstractStore.Configuration {
    }
}

