/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.ReadOnlyDatabaseKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;

public class NodeProxy
implements Node {
    private final NodeLookup nodeLookup;
    private final ThreadToStatementContextBridge statementContextProvider;
    private final long nodeId;

    NodeProxy(long nodeId, NodeLookup nodeLookup, ThreadToStatementContextBridge statementContextProvider) {
        this.nodeId = nodeId;
        this.nodeLookup = nodeLookup;
        this.statementContextProvider = statementContextProvider;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeLookup.getGraphDatabase();
    }

    @Override
    public void delete() {
        try (Statement statement = this.statementContextProvider.instance();){
            statement.dataWriteOperations().nodeDelete(this.getId());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager());
    }

    @Override
    public boolean hasRelationship() {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager());
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        this.assertInTransaction();
        return this.nodeLookup.lookup(this.nodeId).getSingleRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    private void assertInTransaction() {
        this.statementContextProvider.assertInTransaction();
    }

    @Override
    public void setProperty(String key, Object value) {
        boolean requireRollback = true;
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            try {
                statement.dataWriteOperations().nodeSetProperty(this.nodeId, Property.property(propertyKeyId, value));
            }
            catch (ConstraintValidationKernelException e) {
                requireRollback = false;
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            requireRollback = false;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
        finally {
            if (requireRollback) {
                this.nodeLookup.getNodeManager().setRollbackOnly();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) throws NotFoundException {
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().nodeRemoveProperty(this.nodeId, propertyKeyId).value(null);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            Object object = statement.readOperations().nodeGetProperty(this.nodeId, propertyKeyId).value(defaultValue);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.statementContextProvider.instance();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<DefinedProperty> properties = statement.readOperations().nodeGetAllProperties(this.getId());
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", e);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.", e);
        }
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.readOperations().nodeGetProperty(this.nodeId, propertyKeyId).value();
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = statement.readOperations().nodeGetProperty(this.nodeId, propertyKeyId).isDefined();
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        if (otherNode == null) {
            throw new IllegalArgumentException("Other node is null.");
        }
        try (Statement statement = this.statementContextProvider.instance();){
            long relationshipTypeId = statement.tokenWriteOperations().relationshipTypeGetOrCreateForName(type.name());
            RelationshipProxy relationshipProxy = this.nodeLookup.getNodeManager().newRelationshipProxyById(statement.dataWriteOperations().relationshipCreate(relationshipTypeId, this.nodeId, otherNode.getId()));
            return relationshipProxy;
        }
        catch (RelationshipTypeIdNotFoundKernelException | IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        this.assertInTransaction();
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    @Override
    public void addLabel(Label label) {
        try (Statement statement = this.statementContextProvider.instance();){
            try {
                statement.dataWriteOperations().nodeAddLabel(this.getId(), statement.tokenWriteOperations().labelGetOrCreateForName(label.name()));
            }
            catch (ConstraintValidationKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
        }
        catch (IllegalTokenNameException e) {
            throw new ConstraintViolationException(String.format("Invalid label name '%s'.", label.name()), e);
        }
        catch (TooManyLabelsException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    @Override
    public void removeLabel(Label label) {
        try (Statement statement = this.statementContextProvider.instance();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            if (labelId != -1) {
                statement.dataWriteOperations().nodeRemoveLabel(this.getId(), labelId);
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (ReadOnlyDatabaseKernelException e) {
            throw new ReadOnlyDbException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasLabel(Label label) {
        try (Statement statement = this.statementContextProvider.instance();){
            int labelId = statement.readOperations().labelGetForName(label.name());
            boolean bl = statement.readOperations().nodeHasLabel(this.getId(), labelId);
            return bl;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<Label> getLabels() {
        try (Statement statement = this.statementContextProvider.instance();){
            PrimitiveIntIterator labels = statement.readOperations().nodeGetLabels(this.getId());
            ArrayList<Label> keys = new ArrayList<Label>();
            while (labels.hasNext()) {
                int labelId = labels.next();
                keys.add(DynamicLabel.label(statement.readOperations().labelGetName(labelId)));
            }
            ArrayList<Label> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node not found", e);
        }
        catch (LabelNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Stefan", "Label retrieved through kernel API should exist.");
        }
    }

    public static interface NodeLookup {
        public NodeImpl lookup(long var1);

        public GraphDatabaseService getGraphDatabase();

        public NodeManager getNodeManager();

        public NodeImpl lookup(long var1, LockType var3);
    }
}

