/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class BytePrinter {
    public static void print(byte[] bytes, PrintStream out) {
        BytePrinter.print(ByteBuffer.wrap(bytes), out, 0, bytes.length);
    }

    public static void print(ByteBuffer bytes, PrintStream out) {
        BytePrinter.print(bytes, out, 0, bytes.capacity());
    }

    public static void print(ByteBuffer bytes, PrintStream out, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            BytePrinter.print(bytes.get(i), out);
            if ((i - offset + 1) % 32 == 0) {
                out.println();
                continue;
            }
            if ((i - offset + 1) % 8 == 0) {
                out.print("    ");
                continue;
            }
            out.print(" ");
        }
    }

    public static void print(byte b, PrintStream out) {
        out.print(BytePrinter.hex(b));
    }

    public static String ljust(String str, int columnWidth) {
        return String.format("%-" + columnWidth + "s", str);
    }

    public static String rjust(String str, int columnWidth) {
        return String.format("%" + columnWidth + "s", str);
    }

    public static String hex(byte b) {
        return String.format("%02x", b);
    }

    public static String hex(ByteBuffer bytes, int offset, int length) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = null;
            ps = new PrintStream((OutputStream)baos, true, "UTF-8");
            BytePrinter.print(bytes, ps, offset, length);
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hex(ByteBuffer bytes) {
        return BytePrinter.hex(bytes, 0, bytes.capacity());
    }

    public static String hex(byte[] bytes) {
        return BytePrinter.hex(ByteBuffer.wrap(bytes));
    }
}

