/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.lifecycle.Lifecycle;

public abstract class XaDataSource
implements Lifecycle {
    private byte[] branchId = null;
    private String name = null;

    public XaDataSource(byte[] branchId, String name) {
        this.branchId = branchId;
        this.name = name;
    }

    public abstract XaConnection getXaConnection();

    public byte[] getBranchId() {
        return this.branchId;
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public File getFileName(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getRandomIdentifier() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getCurrentLogVersion() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long rotateLogicalLog() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean hasLogicalLog(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getLogicalLogLength(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean deleteLogicalLog(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setAutoRotate(boolean rotate) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Deprecated
    public void setLogicalLogTargetSize(long size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void getPreparedTransaction(int identifier, LogBuffer targetBuffer) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void applyCommittedTransaction(long txId, ReadableByteChannel transaction) throws IOException {
        this.getXaContainer().getResourceManager().applyCommittedTransaction(transaction, txId);
    }

    public long applyPreparedTransaction(ReadableByteChannel transaction) throws IOException {
        return this.getXaContainer().getResourceManager().applyPreparedTransaction(transaction);
    }

    public long getLastCommittedTxId() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setLastCommittedTxId(long txId) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public XaContainer getXaContainer() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Pair<Integer, Long> getMasterForCommittedTx(long txId) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ResourceIterator<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean setRecovered(boolean recovered) {
        return false;
    }

    public LogExtractor getLogExtractor(long startTxId, long endTxIdHint) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

