/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.nio.ByteBuffer;
import java.util.Random;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid {
    private static final int FORMAT_ID = 1313164849;
    private static final byte[] INSTANCE_ID = new byte[]{78, 69, 79, 75, 69, 82, 78, 76, 0};
    private static long nextSequenceId = 0L;
    private final byte[] globalId;
    private final byte[] branchId;
    private static final Random r = new Random(System.currentTimeMillis());
    private volatile int hashCode = 0;

    private static synchronized long getNextSequenceId() {
        return nextSequenceId++;
    }

    public static byte[] getNewGlobalId() {
        byte[] globalId = new byte[INSTANCE_ID.length + 16];
        System.arraycopy(INSTANCE_ID, 0, globalId, 0, INSTANCE_ID.length);
        ByteBuffer byteBuf = ByteBuffer.wrap(globalId);
        byteBuf.position(INSTANCE_ID.length);
        long time = r.nextLong();
        long sequence = XidImpl.getNextSequenceId();
        byteBuf.putLong(time).putLong(sequence);
        return globalId;
    }

    static boolean isThisTm(byte[] globalId) {
        if (globalId.length < INSTANCE_ID.length) {
            return false;
        }
        for (int i = 0; i < INSTANCE_ID.length; ++i) {
            if (globalId[i] == INSTANCE_ID[i]) continue;
            return false;
        }
        return true;
    }

    public XidImpl(byte[] globalId, byte[] resourceId) {
        if (globalId.length > 64) {
            throw new IllegalArgumentException("GlobalId length to long: " + globalId.length + ". Max is " + 64);
        }
        if (resourceId.length > 64) {
            throw new IllegalArgumentException("BranchId (resource id) to long, " + resourceId.length);
        }
        this.globalId = globalId;
        this.branchId = resourceId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this.branchId.clone();
    }

    @Override
    public int getFormatId() {
        return 1313164849;
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof Xid)) {
            return false;
        }
        byte[] otherGlobalId = ((Xid)o).getGlobalTransactionId();
        byte[] otherBranchId = ((Xid)o).getBranchQualifier();
        if (this.globalId.length != otherGlobalId.length || this.branchId.length != otherBranchId.length) {
            return false;
        }
        for (i = 0; i < this.globalId.length; ++i) {
            if (this.globalId[i] == otherGlobalId[i]) continue;
            return false;
        }
        for (i = 0; i < this.branchId.length; ++i) {
            if (this.branchId[i] == otherBranchId[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int calcHash = 0;
            for (int i = 0; i < 3 && i < this.globalId.length; ++i) {
                calcHash += this.globalId[this.globalId.length - i - 1] << i * 8;
            }
            if (this.branchId.length > 0) {
                calcHash += this.branchId[0] << 24;
            }
            this.hashCode = 3217 * calcHash;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("GlobalId[");
        if (this.globalId.length == INSTANCE_ID.length + 8 + 8) {
            for (int i = 0; i < INSTANCE_ID.length - 1; ++i) {
                buf.append((char)this.globalId[i]);
            }
            ByteBuffer byteBuf = ByteBuffer.wrap(this.globalId);
            byteBuf.position(INSTANCE_ID.length);
            long time = byteBuf.getLong();
            long sequence = byteBuf.getLong();
            buf.append('|');
            buf.append(time);
            buf.append('|');
            buf.append(sequence);
        } else {
            buf.append("UNKNOWN_ID");
        }
        buf.append("], BranchId[ ");
        for (int i = 0; i < this.branchId.length; ++i) {
            buf.append(this.branchId[i] + " ");
        }
        buf.append("]");
        return buf.toString();
    }
}

