/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cleanup;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Thunk;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.impl.cleanup.AutoCleanupResourceIterator;
import org.neo4j.kernel.impl.cleanup.CleanupReference;
import org.neo4j.kernel.impl.cleanup.CleanupReferenceQueue;
import org.neo4j.kernel.impl.cleanup.CleanupService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.logging.Logging;

class ReferenceQueueBasedCleanupService
extends CleanupService
implements Runnable {
    private volatile boolean running;
    private final JobScheduler scheduler;
    private final Thunk<Boolean> cleanupNecessity;
    final CleanupReferenceQueue collectedReferences;
    CleanupReference first;

    ReferenceQueueBasedCleanupService(JobScheduler scheduler, Logging logging, CleanupReferenceQueue collectedReferences, Thunk<Boolean> cleanupNecessity) {
        super(logging);
        this.scheduler = scheduler;
        this.collectedReferences = collectedReferences;
        this.cleanupNecessity = cleanupNecessity;
    }

    @Override
    public <T> ResourceIterator<T> resourceIterator(Iterator<T> iterator, Resource resource) {
        if (this.cleanupNecessity.evaluate().booleanValue()) {
            return this.linked(new AutoCleanupResourceIterator<T>(iterator), resource);
        }
        return ResourceClosingIterator.newResourceIterator(resource, iterator);
    }

    private <T> ResourceIterator<T> linked(AutoCleanupResourceIterator<T> iterator, Resource handler) {
        CleanupReference cleanup = new CleanupReference(iterator, this, handler);
        this.link(cleanup);
        iterator.cleanup = cleanup;
        return iterator;
    }

    @Override
    public void start() {
        this.running = true;
        this.scheduler.scheduleRecurring(this, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (this.running) {
            CleanupReference reference;
            while (this.running && (reference = this.collectedReferences.remove()) != null) {
                this.cleanup(reference);
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        CleanupReference cur = this.first;
        while (cur != null) {
            this.cleanup(cur);
            cur = cur.next;
        }
        this.first = null;
    }

    synchronized void link(CleanupReference reference) {
        CleanupReference next;
        reference.next = next = this.first;
        this.first = reference;
        if (next != null) {
            next.prev = reference;
        }
    }

    synchronized void unlink(CleanupReference reference) {
        CleanupReference prev = reference.prev;
        CleanupReference next = reference.next;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
        }
        if (next != null) {
            next.prev = prev;
        }
    }
}

