/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cleanup;

import java.lang.ref.PhantomReference;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.cleanup.ReferenceQueueBasedCleanupService;

class CleanupReference
extends PhantomReference<Object> {
    private final ReferenceQueueBasedCleanupService cleanupService;
    private final String referenceDescription;
    private Resource resource;
    CleanupReference prev;
    CleanupReference next;

    CleanupReference(Object referent, ReferenceQueueBasedCleanupService cleanupService, Resource resource) {
        super(referent, cleanupService.collectedReferences.queue);
        this.referenceDescription = referent.toString();
        this.cleanupService = cleanupService;
        this.resource = resource;
    }

    public String description() {
        return this.referenceDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupNow(boolean explicit) {
        boolean shouldUnlink = false;
        try {
            CleanupReference cleanupReference = this;
            synchronized (cleanupReference) {
                if (this.resource != null) {
                    shouldUnlink = true;
                    if (!explicit) {
                        this.cleanupService.logLeakedReference(this);
                    }
                    try {
                        this.resource.close();
                    }
                    finally {
                        this.resource = null;
                    }
                }
            }
        }
        finally {
            if (shouldUnlink) {
                this.cleanupService.unlink(this);
            }
        }
    }
}

