/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.kernel.impl.util.StringLogger;

public class MeasureDoNothing
extends Thread {
    private volatile boolean measure = true;
    private volatile long timeBlocked = 0L;
    private final long TIME_TO_WAIT;
    private final long TIME_BEFORE_BLOCK;
    private final StringLogger logger;

    public MeasureDoNothing(String threadName, StringLogger logger) {
        super(threadName);
        if (logger == null) {
            throw new IllegalArgumentException("Null message log");
        }
        this.logger = logger;
        this.TIME_TO_WAIT = 100L;
        this.TIME_BEFORE_BLOCK = 200L;
        this.setDaemon(true);
    }

    public MeasureDoNothing(String threadName, StringLogger logger, long timeToWait, long acceptableWaitTime) {
        super(threadName);
        if (logger == null) {
            throw new IllegalArgumentException("Null message log");
        }
        if (timeToWait >= acceptableWaitTime) {
            throw new IllegalArgumentException("timeToWait[" + timeToWait + "] should be less than acceptableWaitTime[" + acceptableWaitTime + "]");
        }
        this.logger = logger;
        this.TIME_TO_WAIT = timeToWait;
        this.TIME_BEFORE_BLOCK = acceptableWaitTime;
        this.setDaemon(true);
    }

    @Override
    public synchronized void run() {
        this.logger.info("GC Monitor started. ");
        while (this.measure) {
            long time;
            long start = System.currentTimeMillis();
            try {
                this.wait(this.TIME_TO_WAIT);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            if ((time = System.currentTimeMillis() - start) <= this.TIME_BEFORE_BLOCK) continue;
            long blockTime = time - this.TIME_TO_WAIT;
            this.timeBlocked += blockTime;
            this.logger.warn("GC Monitor: Application threads blocked for an additional " + blockTime + "ms [total block time: " + (float)this.timeBlocked / 1000.0f + "s]");
        }
        this.logger.info("GC Monitor stopped. ");
    }

    public synchronized void stopMeasuring() {
        this.measure = false;
        this.interrupt();
    }

    public long getTimeInBlock() {
        return this.timeBlocked;
    }
}

