/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.Transactor;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class RemoveOrphanConstraintIndexesOnStartup {
    private final StringLogger log;
    private final Transactor transactor;

    public RemoveOrphanConstraintIndexesOnStartup(Transactor transactor, Logging logging) {
        this.transactor = transactor;
        this.log = logging.getMessagesLog(this.getClass());
    }

    public void perform() {
        try {
            this.transactor.execute(new Transactor.Work<Void, KernelException>(){

                @Override
                public Void perform(Statement state) throws KernelException {
                    Iterator<IndexDescriptor> indexes = state.readOperations().uniqueIndexesGetAll();
                    while (indexes.hasNext()) {
                        IndexDescriptor index = indexes.next();
                        if (state.readOperations().indexGetOwningUniquenessConstraintId(index) != null) continue;
                        state.schemaWriteOperations().uniqueIndexDrop(index);
                    }
                    return null;
                }
            });
        }
        catch (KernelException | TransactionalException e) {
            this.log.error("Failed to execute orphan index checking transaction.", e);
        }
    }
}

