/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.logging.Logging;

public class PopulatingIndexProxy
implements IndexProxy {
    private final JobScheduler scheduler;
    private final IndexDescriptor descriptor;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final IndexPopulationJob job;

    public PopulatingIndexProxy(JobScheduler scheduler, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, FailedIndexProxyFactory failureDelegateFactory, IndexPopulator writer, FlippableIndexProxy flipper, IndexStoreView storeView, String indexUserDescription, UpdateableSchemaState updateableSchemaState, Logging logging) {
        this.scheduler = scheduler;
        this.descriptor = descriptor;
        this.providerDescriptor = providerDescriptor;
        this.job = new IndexPopulationJob(descriptor, providerDescriptor, indexUserDescription, failureDelegateFactory, writer, flipper, storeView, updateableSchemaState, logging);
    }

    @Override
    public void start() {
        this.scheduler.schedule(this.job);
    }

    @Override
    public IndexUpdater newUpdater(final IndexUpdateMode mode) {
        return new IndexUpdater(){

            @Override
            public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                switch (mode) {
                    case ONLINE: {
                        PopulatingIndexProxy.this.job.update(update);
                        break;
                    }
                    case RECOVERY: {
                        throw new UnsupportedOperationException("Recovered updates shouldn't reach this place");
                    }
                    default: {
                        throw new ThisShouldNotHappenError("Stefan", "Unsupported IndexUpdateMode");
                    }
                }
            }

            @Override
            public void close() throws IOException, IndexEntryConflictException {
            }

            @Override
            public void remove(Iterable<Long> nodeIds) {
                throw new UnsupportedOperationException("Should not remove() from populating index.");
            }
        };
    }

    @Override
    public Future<Void> drop() {
        return this.job.cancel();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.POPULATING;
    }

    @Override
    public void force() {
    }

    @Override
    public Future<Void> close() {
        return this.job.cancel();
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException(this.descriptor + " is still populating");
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        this.job.awaitCompletion();
        return true;
    }

    @Override
    public void activate() throws IndexActivationFailedKernelException {
        throw new IllegalStateException("Cannot activate index while it is still populating.");
    }

    @Override
    public void validate() {
        throw new IllegalStateException("Cannot validate index while it is still populating.");
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return IteratorUtil.emptyIterator();
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is POPULATING");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[job:" + this.job + "]";
    }
}

