/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.Thunk;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.KernelStatement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CacheLoader;
import org.neo4j.kernel.impl.api.CacheUpdateListener;
import org.neo4j.kernel.impl.api.PrimitiveLongIterator;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.RelationshipImpl;

public class PersistenceCache {
    private final CacheUpdateListener NODE_CACHE_SIZE_LISTENER = new CacheUpdateListener(){

        @Override
        public void newSize(Primitive entity, int size) {
            PersistenceCache.this.nodeCache.updateSize((NodeImpl)entity, size);
        }
    };
    private final CacheUpdateListener RELATIONSHIP_CACHE_SIZE_LISTENER = new CacheUpdateListener(){

        @Override
        public void newSize(Primitive entity, int size) {
            PersistenceCache.this.relationshipCache.updateSize((RelationshipImpl)entity, size);
        }
    };
    private final AutoLoadingCache<NodeImpl> nodeCache;
    private final AutoLoadingCache<RelationshipImpl> relationshipCache;
    private final Thunk<GraphPropertiesImpl> graphProperties;

    public PersistenceCache(AutoLoadingCache<NodeImpl> nodeCache, AutoLoadingCache<RelationshipImpl> relationshipCache, Thunk<GraphPropertiesImpl> graphProperties) {
        this.nodeCache = nodeCache;
        this.relationshipCache = relationshipCache;
        this.graphProperties = graphProperties;
    }

    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId, CacheLoader<int[]> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).hasLabel(state, labelId, cacheLoader);
    }

    public int[] nodeGetLabels(KernelStatement state, long nodeId, CacheLoader<int[]> loader) throws EntityNotFoundException {
        return this.getNode(nodeId).getLabels(state, loader);
    }

    private NodeImpl getNode(long nodeId) throws EntityNotFoundException {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        return node;
    }

    private RelationshipImpl getRelationship(long relationshipId) throws EntityNotFoundException {
        RelationshipImpl relationship = this.relationshipCache.get(relationshipId);
        if (relationship == null) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        return relationship;
    }

    public void apply(Collection<NodeLabelUpdate> updates) {
        for (NodeLabelUpdate update : updates) {
            NodeImpl node = this.nodeCache.getIfCached(update.getNodeId());
            if (node == null) continue;
            long[] labelsAfter = update.getLabelsAfter();
            int[] labels = new int[labelsAfter.length];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = (int)labelsAfter[i];
            }
            node.commitLabels(labels);
        }
    }

    public void evictNode(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public Iterator<DefinedProperty> nodeGetProperties(KernelStatement state, long nodeId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getProperties(state, cacheLoader, this.NODE_CACHE_SIZE_LISTENER);
    }

    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getPropertyKeys(state, cacheLoader, this.NODE_CACHE_SIZE_LISTENER);
    }

    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getProperty(state, cacheLoader, this.NODE_CACHE_SIZE_LISTENER, propertyKeyId);
    }

    public Iterator<DefinedProperty> relationshipGetProperties(KernelStatement state, long relationshipId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getProperties(state, cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER);
    }

    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getProperty(state, cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER, propertyKeyId);
    }

    public Iterator<DefinedProperty> graphGetProperties(KernelStatement state, CacheLoader<Iterator<DefinedProperty>> cacheLoader) {
        return this.graphProperties.evaluate().getProperties(state, cacheLoader, CacheUpdateListener.NO_UPDATES);
    }

    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state, CacheLoader<Iterator<DefinedProperty>> cacheLoader) {
        return this.graphProperties.evaluate().getPropertyKeys(state, cacheLoader, CacheUpdateListener.NO_UPDATES);
    }

    public Property graphGetProperty(KernelStatement state, CacheLoader<Iterator<DefinedProperty>> cacheLoader, int propertyKeyId) {
        return this.graphProperties.evaluate().getProperty(state, cacheLoader, CacheUpdateListener.NO_UPDATES, propertyKeyId);
    }
}

