/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.BeginTransactionFailureException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.impl.persistence.PersistenceManager;

public class Transactor {
    private final TransactionManager txManager;
    private final PersistenceManager persistenceManager;

    public Transactor(TransactionManager txManager, PersistenceManager persistenceManager) {
        this.txManager = txManager;
        this.persistenceManager = persistenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT, FAILURE extends KernelException> RESULT execute(Work<RESULT, FAILURE> work) throws FAILURE, TransactionalException {
        Transaction previousTransaction = this.suspendTransaction();
        try {
            RESULT RESULT;
            block25: {
                block24: {
                    this.beginTransaction();
                    KernelTransaction tx = this.persistenceManager.currentKernelTransaction();
                    boolean success = false;
                    try {
                        RESULT result;
                        try (Statement statement = tx.acquireStatement();){
                            result = work.perform(statement);
                        }
                        success = true;
                        RESULT = result;
                        if (!success) break block24;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (success) {
                                this.txManager.commit();
                            } else {
                                this.txManager.rollback();
                            }
                            throw throwable;
                        }
                        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException | TransactionalException failure) {
                            previousTransaction = null;
                            throw new TransactionFailureException((Exception)failure);
                        }
                    }
                    this.txManager.commit();
                    break block25;
                }
                this.txManager.rollback();
            }
            return RESULT;
        }
        finally {
            if (previousTransaction != null) {
                this.resumeTransaction(previousTransaction);
            }
        }
    }

    private void beginTransaction() throws BeginTransactionFailureException {
        try {
            this.txManager.begin();
        }
        catch (NotSupportedException | SystemException e) {
            throw new BeginTransactionFailureException((Exception)e);
        }
    }

    private Transaction suspendTransaction() throws TransactionFailureException {
        Transaction existingTransaction;
        try {
            existingTransaction = this.txManager.suspend();
        }
        catch (SystemException failure) {
            throw new TransactionFailureException(failure);
        }
        return existingTransaction;
    }

    private void resumeTransaction(Transaction existingTransaction) throws TransactionFailureException {
        try {
            this.txManager.resume(existingTransaction);
        }
        catch (InvalidTransactionException failure) {
            throw new ThisShouldNotHappenError("Tobias Lindaaker", "Transaction resumed in the same transaction manager as it was suspended from should not be invalid. The Neo4j code base does not throw InvalidTransactionException", failure);
        }
        catch (SystemException failure) {
            throw new TransactionFailureException(failure);
        }
    }

    public static interface Work<RESULT, FAILURE extends KernelException> {
        public RESULT perform(Statement var1) throws FAILURE;
    }
}

