/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.TransactionManager;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class DatabaseAvailability
implements Lifecycle {
    private TransactionManager txManager;
    private AvailabilityGuard availabilityGuard;

    public DatabaseAvailability(TransactionManager txManager, AvailabilityGuard availabilityGuard) {
        this.txManager = txManager;
        this.availabilityGuard = availabilityGuard;
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
        this.availabilityGuard.grant();
    }

    @Override
    public void stop() throws Throwable {
        this.availabilityGuard.deny();
        if (this.txManager instanceof TxManager) {
            long deadline = Clock.SYSTEM_CLOCK.currentTimeMillis() + 20000L;
            TxManager realTxManager = (TxManager)this.txManager;
            while (realTxManager.getActiveTxCount() > 0 && Clock.SYSTEM_CLOCK.currentTimeMillis() < deadline) {
                Thread.yield();
            }
        }
    }

    @Override
    public void shutdown() throws Throwable {
    }
}

