/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LongerShortString;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.ShortArray;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class PropertyStore
extends AbstractStore
implements Store,
RecordStore<PropertyRecord> {
    public static final int DEFAULT_DATA_BLOCK_SIZE = 120;
    public static final int DEFAULT_PAYLOAD_SIZE = 32;
    public static final String TYPE_DESCRIPTOR = "PropertyStore";
    public static final int RECORD_SIZE = 41;
    private DynamicStringStore stringPropertyStore;
    private PropertyKeyTokenStore propertyKeyTokenStore;
    private DynamicArrayStore arrayPropertyStore;
    private final PropertyPhysicalToLogicalConverter physicalToLogicalConverter;

    public PropertyStore(File fileName, Config configuration, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore stringPropertyStore, PropertyKeyTokenStore propertyKeyTokenStore, DynamicArrayStore arrayPropertyStore) {
        super(fileName, configuration, IdType.PROPERTY, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
        this.stringPropertyStore = stringPropertyStore;
        this.propertyKeyTokenStore = propertyKeyTokenStore;
        this.arrayPropertyStore = arrayPropertyStore;
        this.physicalToLogicalConverter = new PropertyPhysicalToLogicalConverter(this);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, PropertyRecord record) throws FAILURE {
        processor.processProperty(this, record);
    }

    public DynamicStringStore getStringStore() {
        return this.stringPropertyStore;
    }

    public DynamicArrayStore getArrayStore() {
        return this.arrayPropertyStore;
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
        this.stringPropertyStore.setRecovered();
        this.propertyKeyTokenStore.setRecovered();
        this.arrayPropertyStore.setRecovered();
    }

    @Override
    protected void unsetRecovered() {
        super.unsetRecovered();
        this.stringPropertyStore.unsetRecovered();
        this.propertyKeyTokenStore.unsetRecovered();
        this.arrayPropertyStore.unsetRecovered();
    }

    @Override
    protected void closeStorage() {
        if (this.stringPropertyStore != null) {
            this.stringPropertyStore.close();
            this.stringPropertyStore = null;
        }
        if (this.propertyKeyTokenStore != null) {
            this.propertyKeyTokenStore.close();
            this.propertyKeyTokenStore = null;
        }
        if (this.arrayPropertyStore != null) {
            this.arrayPropertyStore.close();
            this.arrayPropertyStore = null;
        }
    }

    @Override
    public void flushAll() {
        this.stringPropertyStore.flushAll();
        this.propertyKeyTokenStore.flushAll();
        this.arrayPropertyStore.flushAll();
        super.flushAll();
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 41;
    }

    @Override
    public int getRecordHeaderSize() {
        return 9;
    }

    public void freeStringBlockId(long blockId) {
        this.stringPropertyStore.freeId(blockId);
    }

    public void freeArrayBlockId(long blockId) {
        this.arrayPropertyStore.freeId(blockId);
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(PropertyRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public void forceUpdateRecord(PropertyRecord record) {
        this.updateRecord(record);
    }

    private void updateRecord(PropertyRecord record, PersistenceWindow window) {
        long id = record.getId();
        this.registerIdFromUpdateRecord(id);
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            short prevModifier = record.getPrevProp() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((record.getPrevProp() & 0xF00000000L) >> 28);
            short nextModifier = record.getNextProp() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((record.getNextProp() & 0xF00000000L) >> 32);
            byte modifiers = (byte)(prevModifier | nextModifier);
            buffer.put(modifiers);
            buffer.putInt((int)record.getPrevProp()).putInt((int)record.getNextProp());
            int longsAppended = 0;
            for (PropertyBlock block : record.getPropertyBlocks()) {
                long[] propBlockValues = block.getValueBlocks();
                for (int k = 0; k < propBlockValues.length; ++k) {
                    buffer.putLong(propBlockValues[k]);
                }
                longsAppended += propBlockValues.length;
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.updateDynamicRecords(block.getValueRecords());
            }
            if (longsAppended < PropertyType.getPayloadSizeLongs()) {
                buffer.putLong(0L);
            }
        } else {
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
            buffer.setOffset(buffer.getOffset() + 9);
            buffer.putLong(0L);
        }
        this.updateDynamicRecords(record.getDeletedRecords());
    }

    private void updateDynamicRecords(List<DynamicRecord> records) {
        for (DynamicRecord valueRecord : records) {
            if (valueRecord.getType() == PropertyType.STRING.intValue()) {
                this.stringPropertyStore.updateRecord(valueRecord);
                continue;
            }
            if (valueRecord.getType() == PropertyType.ARRAY.intValue()) {
                this.arrayPropertyStore.updateRecord(valueRecord);
                continue;
            }
            throw new InvalidRecordException("Unknown dynamic record" + valueRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyRecord getLightRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            PropertyRecord propertyRecord = this.getRecord(id, window, RecordLoad.NORMAL);
            return propertyRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public void ensureHeavy(PropertyBlock block) {
        block7: {
            block6: {
                if (block.getType() != PropertyType.STRING) break block6;
                if (block.isLight()) {
                    Collection<DynamicRecord> stringRecords = this.stringPropertyStore.getLightRecords(block.getSingleValueLong());
                    for (DynamicRecord stringRecord : stringRecords) {
                        stringRecord.setType(PropertyType.STRING.intValue());
                        block.addValueRecord(stringRecord);
                    }
                }
                for (DynamicRecord stringRecord : block.getValueRecords()) {
                    this.stringPropertyStore.ensureHeavy(stringRecord);
                }
                break block7;
            }
            if (block.getType() != PropertyType.ARRAY) break block7;
            if (block.isLight()) {
                Collection<DynamicRecord> arrayRecords = this.arrayPropertyStore.getLightRecords(block.getSingleValueLong());
                for (DynamicRecord arrayRecord : arrayRecords) {
                    arrayRecord.setType(PropertyType.ARRAY.intValue());
                    block.addValueRecord(arrayRecord);
                }
            }
            for (DynamicRecord arrayRecord : block.getValueRecords()) {
                this.arrayPropertyStore.ensureHeavy(arrayRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyRecord getRecord(long id) {
        PropertyRecord record;
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            record = this.getRecord(id, window, RecordLoad.NORMAL);
        }
        finally {
            this.releaseWindow(window);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyRecord forceGetRecord(long id) {
        PersistenceWindow window;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return new PropertyRecord(id);
        }
        try {
            PropertyRecord propertyRecord = this.getRecord(id, window, RecordLoad.FORCE);
            return propertyRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public PropertyRecord forceGetRaw(PropertyRecord record) {
        return record;
    }

    @Override
    public PropertyRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    private PropertyRecord getRecordFromBuffer(long id, Buffer buffer) {
        PropertyBlock newBlock;
        int offsetAtBeggining = buffer.getOffset();
        PropertyRecord record = new PropertyRecord(id);
        byte modifiers = buffer.get();
        long prevMod = ((long)modifiers & 0xF0L) << 28;
        long nextMod = ((long)modifiers & 0xFL) << 32;
        long prevProp = buffer.getUnsignedInt();
        long nextProp = buffer.getUnsignedInt();
        record.setPrevProp(this.longFromIntAndMod(prevProp, prevMod));
        record.setNextProp(this.longFromIntAndMod(nextProp, nextMod));
        while (buffer.getOffset() - offsetAtBeggining < 41 && (newBlock = this.getPropertyBlock(buffer)) != null) {
            record.addPropertyBlock(newBlock);
            record.setInUse(true);
        }
        return record;
    }

    private PropertyRecord getRecord(long id, PersistenceWindow window, RecordLoad load) {
        Buffer buffer = window.getOffsettedBuffer(id);
        PropertyRecord toReturn = this.getRecordFromBuffer(id, buffer);
        if (!toReturn.inUse() && load != RecordLoad.FORCE) {
            throw new InvalidRecordException("PropertyRecord[" + id + "] not in use");
        }
        return toReturn;
    }

    private PropertyBlock getPropertyBlock(Buffer buffer) {
        long header = buffer.getLong();
        PropertyType type = PropertyType.getPropertyType(header, true);
        if (type == null) {
            return null;
        }
        PropertyBlock toReturn = new PropertyBlock();
        int numBlocks = type.calculateNumberOfBlocksUsed(header);
        long[] blockData = new long[numBlocks];
        blockData[0] = header;
        for (int i = 1; i < numBlocks; ++i) {
            blockData[i] = buffer.getLong();
        }
        toReturn.setValueBlocks(blockData);
        return toReturn;
    }

    public Object getValue(PropertyBlock propertyBlock) {
        return propertyBlock.getType().getValue(propertyBlock, this);
    }

    @Override
    public void makeStoreOk() {
        this.propertyKeyTokenStore.makeStoreOk();
        this.stringPropertyStore.makeStoreOk();
        this.arrayPropertyStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.propertyKeyTokenStore.rebuildIdGenerators();
        this.stringPropertyStore.rebuildIdGenerators();
        this.arrayPropertyStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.propertyKeyTokenStore.updateIdGenerators();
        this.stringPropertyStore.updateHighId();
        this.arrayPropertyStore.updateHighId();
        this.updateHighId();
    }

    private Collection<DynamicRecord> allocateStringRecords(byte[] chars) {
        return this.stringPropertyStore.allocateRecordsFromBytes(chars);
    }

    private Collection<DynamicRecord> allocateArrayRecords(Object array) {
        return this.arrayPropertyStore.allocateRecords(array);
    }

    public void encodeValue(PropertyBlock block, int keyId, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (LongerShortString.encode(keyId, string, block, PropertyType.getPayloadSize())) {
                return;
            }
            byte[] encodedString = PropertyStore.encodeString(string);
            Collection<DynamicRecord> valueRecords = this.allocateStringRecords(encodedString);
            this.setSingleBlockValue(block, keyId, PropertyType.STRING, IteratorUtil.first(valueRecords).getId());
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
                block.addValueRecord(valueRecord);
            }
        } else if (value instanceof Integer) {
            this.setSingleBlockValue(block, keyId, PropertyType.INT, ((Integer)value).longValue());
        } else if (value instanceof Boolean) {
            this.setSingleBlockValue(block, keyId, PropertyType.BOOL, (Boolean)value != false ? 1L : 0L);
        } else if (value instanceof Float) {
            this.setSingleBlockValue(block, keyId, PropertyType.FLOAT, Float.floatToRawIntBits(((Float)value).floatValue()));
        } else if (value instanceof Long) {
            long keyAndType = (long)keyId | (long)PropertyType.LONG.intValue() << 24;
            if (ShortArray.LONG.getRequiredBits((Long)value) <= 35) {
                block.setSingleBlock(keyAndType | 0x10000000L | (Long)value << 29);
            } else {
                block.setValueBlocks(new long[]{keyAndType, (Long)value});
            }
        } else if (value instanceof Double) {
            block.setValueBlocks(new long[]{(long)keyId | (long)PropertyType.DOUBLE.intValue() << 24, Double.doubleToRawLongBits((Double)value)});
        } else if (value instanceof Byte) {
            this.setSingleBlockValue(block, keyId, PropertyType.BYTE, ((Byte)value).longValue());
        } else if (value instanceof Character) {
            this.setSingleBlockValue(block, keyId, PropertyType.CHAR, ((Character)value).charValue());
        } else if (value instanceof Short) {
            this.setSingleBlockValue(block, keyId, PropertyType.SHORT, ((Short)value).longValue());
        } else if (value.getClass().isArray()) {
            if (ShortArray.encode(keyId, value, block, PropertyType.getPayloadSize())) {
                return;
            }
            Collection<DynamicRecord> arrayRecords = this.allocateArrayRecords(value);
            this.setSingleBlockValue(block, keyId, PropertyType.ARRAY, IteratorUtil.first(arrayRecords).getId());
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
                block.addValueRecord(valueRecord);
            }
        } else {
            throw new IllegalArgumentException("Unknown property type on: " + value + ", " + value.getClass());
        }
    }

    private void setSingleBlockValue(PropertyBlock block, int keyId, PropertyType type, long longValue) {
        block.setSingleBlock((long)keyId | (long)type.intValue() << 24 | longValue << 28);
    }

    public static byte[] encodeString(String string) {
        return UTF8.encode(string);
    }

    public static Object decodeString(byte[] byteArray) {
        return UTF8.decode(byteArray);
    }

    public Object getStringFor(PropertyBlock propertyBlock) {
        this.ensureHeavy(propertyBlock);
        return this.getStringFor(propertyBlock.getSingleValueLong(), propertyBlock.getValueRecords());
    }

    public Object getStringFor(long startRecord, Collection<DynamicRecord> dynamicRecords) {
        Pair<byte[], byte[]> source = this.stringPropertyStore.readFullByteArray(dynamicRecords, PropertyType.STRING);
        return PropertyStore.decodeString(source.other());
    }

    public Object getArrayFor(PropertyBlock propertyBlock) {
        this.ensureHeavy(propertyBlock);
        return this.getArrayFor(propertyBlock.getValueRecords());
    }

    public Object getArrayFor(Iterable<DynamicRecord> records) {
        return this.arrayPropertyStore.getRightArray(this.arrayPropertyStore.readFullByteArray(records, PropertyType.ARRAY));
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.stringPropertyStore.getWindowPoolStats());
        list.add(this.arrayPropertyStore.getWindowPoolStats());
        list.add(this.getWindowPoolStats());
        return list;
    }

    @Override
    public void logAllWindowPoolStats(StringLogger.LineLogger logger) {
        super.logAllWindowPoolStats(logger);
        this.propertyKeyTokenStore.logAllWindowPoolStats(logger);
        logger.logLine(this.stringPropertyStore.getWindowPoolStats().toString());
        logger.logLine(this.arrayPropertyStore.getWindowPoolStats().toString());
    }

    public int getStringBlockSize() {
        return this.stringPropertyStore.getBlockSize();
    }

    public int getArrayBlockSize() {
        return this.arrayPropertyStore.getBlockSize();
    }

    @Override
    protected boolean isRecordInUse(ByteBuffer buffer) {
        Buffer fromByteBuffer = new Buffer(null, buffer);
        return buffer.limit() >= 41 && this.getRecordFromBuffer(0L, fromByteBuffer).inUse();
    }

    @Override
    public void logVersions(StringLogger.LineLogger logger) {
        super.logVersions(logger);
        this.propertyKeyTokenStore.logVersions(logger);
        this.stringPropertyStore.logVersions(logger);
        this.arrayPropertyStore.logVersions(logger);
    }

    @Override
    public void logIdUsage(StringLogger.LineLogger logger) {
        super.logIdUsage(logger);
        this.propertyKeyTokenStore.logIdUsage(logger);
        this.stringPropertyStore.logIdUsage(logger);
        this.arrayPropertyStore.logIdUsage(logger);
    }

    @Override
    public String toString() {
        return super.toString() + "[blocksPerRecord:" + PropertyType.getPayloadSizeLongs() + "]";
    }

    public Collection<PropertyRecord> getPropertyRecordChain(long firstRecordId) {
        long nextProp = firstRecordId;
        LinkedList<PropertyRecord> toReturn = new LinkedList<PropertyRecord>();
        if (nextProp == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return null;
        }
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getLightRecord(nextProp);
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    public Iterable<NodePropertyUpdate> toLogicalUpdates(PropertyRecord before, long[] nodeLabelsBefore, PropertyRecord after, long[] nodeLabelsAfter) {
        return this.physicalToLogicalConverter.apply(before, nodeLabelsBefore, after, nodeLabelsAfter);
    }

    public static abstract class Configuration
    extends AbstractStore.Configuration {
    }
}

