/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.cleanup.CleanupService;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;

public class NodeProxy
implements Node {
    private final NodeLookup nodeLookup;
    private final ThreadToStatementContextBridge statementCtxProvider;
    private final long nodeId;

    NodeProxy(long nodeId, NodeLookup nodeLookup, ThreadToStatementContextBridge statementCtxProvider) {
        this.nodeId = nodeId;
        this.nodeLookup = nodeLookup;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public long getId() {
        return this.nodeId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeLookup.getGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        StatementContext ctxForWriting = this.statementCtxProvider.getCtxForWriting();
        try {
            ctxForWriting.nodeDelete(this.getId());
        }
        finally {
            ctxForWriting.close();
        }
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager());
    }

    @Override
    public boolean hasRelationship() {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager());
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), direction, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getRelationships(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).hasRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        return this.nodeLookup.lookup(this.nodeId).getSingleRelationship(this.nodeLookup.getNodeManager(), type, dir);
    }

    @Override
    public void setProperty(String key, Object value) {
        StatementContext ctxForWriting = this.statementCtxProvider.getCtxForWriting();
        try {
            long propertyKeyId = ctxForWriting.propertyKeyGetOrCreateForName(key);
            ctxForWriting.nodeSetProperty(this.nodeId, Property.property(propertyKeyId, value));
        }
        catch (PropertyKeyIdNotFoundException e) {
            throw new ThisShouldNotHappenError("Stefan/Jake", "A property key id disappeared under our feet");
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            ctxForWriting.close();
        }
    }

    @Override
    public Object removeProperty(String key) throws NotFoundException {
        StatementContext ctxForWriting = this.statementCtxProvider.getCtxForWriting();
        try {
            long propertyId = ctxForWriting.propertyKeyGetOrCreateForName(key);
            Object object = ctxForWriting.nodeRemoveProperty(this.nodeId, propertyId).value(null);
            return object;
        }
        catch (PropertyKeyIdNotFoundException e) {
            throw new ThisShouldNotHappenError("Stefan/Jake", "A property key id disappeared under our feet");
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            ctxForWriting.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        StatementContext ctxForReading = this.statementCtxProvider.getCtxForReading();
        try {
            long propertyId = ctxForReading.propertyKeyGetForName(key);
            Object object = ctxForReading.nodeGetProperty(this.nodeId, propertyId).value(defaultValue);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (PropertyKeyIdNotFoundException e) {
            Object object = defaultValue;
            return object;
        }
        catch (PropertyKeyNotFoundException e) {
            Object object = defaultValue;
            return object;
        }
        finally {
            ctxForReading.close();
        }
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.nodeLookup.lookup(this.nodeId).getPropertyValues(this.nodeLookup.getNodeManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        final StatementContext context = this.statementCtxProvider.getCtxForReading();
        try {
            Set<String> set = IteratorUtil.asSet(Iterables.map(new Function<Long, String>(){

                @Override
                public String apply(Long aLong) {
                    try {
                        return context.propertyKeyGetName(aLong);
                    }
                    catch (PropertyKeyIdNotFoundException e) {
                        throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
                    }
                }
            }, context.nodeGetPropertyKeys(this.getId())));
            return set;
        }
        finally {
            context.close();
        }
    }

    @Override
    public Object getProperty(String key) throws NotFoundException {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        StatementContext ctxForReading = this.statementCtxProvider.getCtxForReading();
        try {
            long propertyId = ctxForReading.propertyKeyGetForName(key);
            Object object = ctxForReading.nodeGetProperty(this.nodeId, propertyId).value();
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (PropertyKeyIdNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (PropertyKeyNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (PropertyNotFoundException e) {
            throw new NotFoundException(e);
        }
        finally {
            ctxForReading.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        StatementContext ctxForReading = this.statementCtxProvider.getCtxForReading();
        try {
            long propertyId = ctxForReading.propertyKeyGetForName(key);
            boolean bl = ctxForReading.nodeHasProperty(this.nodeId, propertyId);
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (PropertyKeyIdNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (PropertyKeyNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            ctxForReading.close();
        }
    }

    public int compareTo(Object node) {
        long theirId;
        Node n = (Node)node;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.nodeLookup.lookup(this.nodeId, LockType.WRITE).createRelationshipTo(this.nodeLookup.getNodeManager(), this, otherNode, type);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    @Override
    public void addLabel(Label label) {
        StatementContext ctx = this.statementCtxProvider.getCtxForWriting();
        try {
            ctx.nodeAddLabel(this.getId(), ctx.labelGetOrCreateForName(label.name()));
        }
        catch (SchemaKernelException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
        finally {
            ctx.close();
        }
    }

    @Override
    public void removeLabel(Label label) {
        long labelId;
        StatementContext ctx = this.statementCtxProvider.getCtxForWriting();
        try {
            labelId = ctx.labelGetForName(label.name());
        }
        catch (LabelNotFoundKernelException e) {
            return;
        }
        try {
            ctx.nodeRemoveLabel(this.getId(), labelId);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", e);
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLabel(Label label) {
        StatementContext ctx = this.statementCtxProvider.getCtxForReading();
        try {
            boolean bl = ctx.nodeHasLabel(this.getId(), ctx.labelGetForName(label.name()));
            return bl;
        }
        catch (LabelNotFoundKernelException e) {
            boolean bl = false;
            return bl;
        }
        catch (EntityNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            ctx.close();
        }
    }

    @Override
    public ResourceIterable<Label> getLabels() {
        return new ResourceIterable<Label>(){

            @Override
            public ResourceIterator<Label> iterator() {
                Iterator<Long> labels;
                final StatementContext ctx = NodeProxy.this.statementCtxProvider.getCtxForReading();
                try {
                    labels = ctx.nodeGetLabels(NodeProxy.this.getId());
                }
                catch (EntityNotFoundException e) {
                    ctx.close();
                    throw new NotFoundException("No node with id " + NodeProxy.this.getId() + " found.", e);
                }
                return NodeProxy.this.nodeLookup.getCleanupService().resourceIterator(Iterables.map(new Function<Long, Label>(){

                    @Override
                    public Label apply(Long labelId) {
                        try {
                            return DynamicLabel.label(ctx.labelGetName(labelId));
                        }
                        catch (LabelNotFoundKernelException e) {
                            throw new ThisShouldNotHappenError("Mattias", "Listed labels for node " + NodeProxy.this.nodeId + ", but the returned label " + labelId + " doesn't exist anymore");
                        }
                    }
                }, labels), ctx);
            }
        };
    }

    public static interface NodeLookup {
        public NodeImpl lookup(long var1);

        public GraphDatabaseService getGraphDatabase();

        public NodeManager getNodeManager();

        public CleanupService getCleanupService();

        public NodeImpl lookup(long var1, LockType var3);
    }
}

